% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assignStrainTraits.R
\name{assignStrainTraits}
\alias{assignStrainTraits}
\title{Internal function to assign stochastic strain traits}
\usage{
assignStrainTraits(numStrains, groupVal, strainOptions, gname,
  parName = "unspecified param", pHtrait = FALSE)
}
\arguments{
\item{numStrains}{Scalar. Number of strains per group}

\item{groupVal}{Scalar. Group parameter value}

\item{strainOptions}{List containing 'distribution' i.e. the shape of the distribution ('normal' or 'uniform' - if distribution is 'normal' then its std dev is percentRange/200, if distribution is 'uniform' then its range is groupVal +/- percentRange); ; 'maxPHshift' max shift in pH units}

\item{gname}{Name of microbial group}

\item{parName}{Name of parameter. This is only used to help with error catching}

\item{pHtrait}{TRUE/FALSE whether or not trait is the pH trait.}
}
\value{
vector of trait values for each strain for one parameter value
}
\description{
Produces a random distribution of trait values where the mean is 1 and the range is determined by percentRange e.g. 10% gives values between 0.9 and 1.1
}

