% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_alpha.R
\name{trans_alpha}
\alias{trans_alpha}
\title{Create trans_alpha object for alpha diveristy statistics and plotting.}
\description{
This class is a wrapper for a series of alpha diveristy related analysis, including the statistics and plotting based on An et al. (2019) <doi:10.1016/j.geoderma.2018.09.035> and Paul et al. (2013) <doi:10.1371/journal.pone.0061217>.
}
\examples{

## ------------------------------------------------
## Method `trans_alpha$new`
## ------------------------------------------------

data(dataset)
t1 <- trans_alpha$new(dataset = dataset, group = "Group")

## ------------------------------------------------
## Method `trans_alpha$cal_diff`
## ------------------------------------------------

t1$cal_diff(method = "KW")
t1$cal_diff(method = "anova")

## ------------------------------------------------
## Method `trans_alpha$plot_alpha`
## ------------------------------------------------

t1$plot_alpha(color_values = RColorBrewer::brewer.pal(12, "Paired"), measure = "Shannon", 
  group = "Group", pair_compare = TRUE)
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{trans_alpha$new()}}
\item \href{#method-cal_diff}{\code{trans_alpha$cal_diff()}}
\item \href{#method-plot_alpha}{\code{trans_alpha$plot_alpha()}}
\item \href{#method-print}{\code{trans_alpha$print()}}
\item \href{#method-clone}{\code{trans_alpha$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_alpha$new(dataset = NULL, group = NULL, order_x = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataset}}{the object of \code{\link{microtable}} Class.}

\item{\code{group}}{default NULL; the sample column used for the statistics; If provided, can return alpha_stat.}

\item{\code{order_x}}{default:null; sample_table column name or a vector containg sample names; if provided, make samples ordered by using factor.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
alpha_data and alpha_stat stored in the object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(dataset)
t1 <- trans_alpha$new(dataset = dataset, group = "Group")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_diff"></a>}}
\if{latex}{\out{\hypertarget{method-cal_diff}{}}}
\subsection{Method \code{cal_diff()}}{
Test the difference of alpha diveristy across groups. If use anova, require agricolae package.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_alpha$cal_diff(method = c("KW", "anova")[1], measures = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{default "KW"; "KW" or "anova"; KW rank sum test or anova for the testing.}

\item{\code{measures}}{default NULL; a vector; if null, all indexes will be calculated; see names of alpha_diversity of dataset, e.g. Observed, Chao1, ACE, Shannon, Simpson, InvSimpson, Fisher, Coverage, PD.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_alpha_diff in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t1$cal_diff(method = "KW")
t1$cal_diff(method = "anova")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_alpha"></a>}}
\if{latex}{\out{\hypertarget{method-plot_alpha}{}}}
\subsection{Method \code{plot_alpha()}}{
Plotting the alpha diveristy.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_alpha$plot_alpha(
  color_values = RColorBrewer::brewer.pal(8, "Dark2"),
  measure = "Shannon",
  group = NULL,
  add_letter = FALSE,
  pair_compare = FALSE,
  pair_compare_filter = "",
  pair_compare_method = "wilcox.test",
  xtext_type = NULL,
  xtext_size = 10,
  ytitle_size = 17,
  base_font = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{color_values}}{colors used for presentation.}

\item{\code{measure}}{default Shannon; alpha diveristy measurement; see names of alpha_diversity of dataset, e.g. Observed, Chao1, ACE, Shannon, Simpson, InvSimpson, Fisher, Coverage, PD.}

\item{\code{group}}{default NULL; group name used for the plot.}

\item{\code{add_letter}}{default FALSE; If TRUE, the letters of duncan test will be added in the plot.}

\item{\code{pair_compare}}{default FALSE; whether perform paired comparisons.}

\item{\code{pair_compare_filter}}{default ""; groups that will be removed.}

\item{\code{pair_compare_method}}{default wilcox.test; wilcox.test, kruskal.test, t.test or anova.}

\item{\code{xtext_type}}{default NULL; number used to make x axis text generate angle.}

\item{\code{xtext_size}}{default 10, x axis text size.}

\item{\code{ytitle_size}}{default 17, y axis title size.}

\item{\code{base_font}}{default NULL, font in the plot.}

\item{\code{...}}{parameters pass to ggpubr::ggboxplot.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t1$plot_alpha(color_values = RColorBrewer::brewer.pal(12, "Paired"), measure = "Shannon", 
  group = "Group", pair_compare = TRUE)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print the trans_alpha object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_alpha$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_alpha$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
