% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_device.R
\name{query_ap_devices}
\alias{query_ap_devices}
\title{AP System multi-device query}
\usage{
query_ap_devices(device_ip, query)
}
\arguments{
\item{device_ip}{list or vector of each device IP address or name}

\item{query}{the API query string}
}
\value{
a data-frame with a `device_id` column and the `$Body$Data` turned into
   as many columns as expected
}
\description{
AP System multi-device query
}
\examples{
\dontrun{
query_ap_devices(device_ip = c("192.168.0.234", "192.168.0.235"),
                 query = "getDeviceInfo"
                 )
}
}
\seealso{
Other device queries: 
\code{\link{query_ap_device}()},
\code{\link{query_enphaseenergy_device}()},
\code{\link{query_enphaseenvoy_device}()},
\code{\link{query_fronius_device}()},
\code{\link{query_fronius_devices}()}
}
\concept{device queries}
