% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkFunctions.R
\name{getMMCurve}
\alias{getMMCurve}
\title{calculate Michealis-Menten relation between x and velocity and rate}
\usage{
getMMCurve(x, Vmax, kappaMM, constantValue = NA)
}
\arguments{
\item{x}{numeric vector,  independent variable in Michaelis-Menten function representing a concentration or dose}

\item{Vmax}{is the maximum rate ( x * Vmax / (kappaMM + x ) ) with increasing x}

\item{kappaMM}{scalar representing Michaelis-Menten constant wich is the x at the rate reaches half of Vmax}

\item{constantValue}{mumeric constant if not \code{NULL} , the rate equals
x*constantValue with  Vmax and kappaMM are ignored,  defaults to \code{NA}}
}
\value{
data.frame given te relation between concentration and velocity and rate with columns
\itemize{
  \item x
  \item velocity wich is rate/concentration
  \item rate rate  ( x * Vmax / (kappaMM + x ) 
  \item Vmax input value
  \item kappaMM input value
}
}
\description{
calculate Michealis-Menten relation between x and velocity and rate
}
\examples{
  getMMCurve( x = seq( 0 , 1 , 0.01 ) , Vmax = 5 , kappaMM = 0.3 )
  getMMCurve( x = seq( 0 , 3 , 0.01 ) , Vmax = 5 , kappaMM = 0.3 )
  getMMCurve( x = seq( 0 , 1 , 0.01 ) , Vmax = 5 , kappaMM = 0.3 , constantValue = 3 ) 
}
