% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objectPkModelRange.R
\name{rankObjectWithRange}
\alias{rankObjectWithRange}
\title{Rank a \code{\link{SetOfSchemes-class}} or a \code{\link{SetOfTimePoints}} object using data generated per scneario defined by \code{\link{PkModelRange-class}}}
\usage{
rankObjectWithRange(object, pkModelRange, nSim,
  summaryFunctionOverScenarios = "max", directory = NULL, nCores = 1,
  seed = 123, ...)
}
\arguments{
\item{object}{to be ranked}

\item{pkModelRange}{see \code{\link{PkModelRange-class}}}

\item{nSim}{number of samples dataset to generate per scenario (= combination of uncertain parameters)}

\item{summaryFunctionOverScenarios}{function to summarize performance over different scenarios, defaults to \code{max} which 
corresponds to the min-max criterion}

\item{directory}{directory to save models as \code{.Rds}  objects, defaults to \code{NULL}
when a temporary directory is made to save models and additional info  on simulation settings, ranks, ...}

\item{nCores}{number of cores used internally for ranking}

\item{seed}{random seed reset when ranking on each directory ( for reproducibility ) , defaults to \code{123}}

\item{...}{additional parameters to pass to \code{\link{rankObject}}}
}
\description{
Rank a \code{\link{SetOfSchemes-class}} or a \code{\link{SetOfTimePoints}} object using data generated per scneario defined by \code{\link{PkModelRange-class}}
}
\note{
parallel computing at level of individual ranking and data generation

see \code{\link{rankObject}} for additional arguments, whem ranking a \code{link{SetOfTimePoints-class}} , \code{nSubjectsPerScheme} should be included

The same random seed is used when using parallel computations
}
\examples{

  \dontrun{ # takes to much time for CRAN
   ## rank SetOfSchemes 
  setOfSchemesExample    <-  getExampleSetOfSchemes()
  pkModelRange           <-  getExamplePkModelRange()
  nSim                   <-  13 
  testDirectory1         <-  file.path( tempdir() , "test1" )
  dir.create( testDirectory1 )
  rankObjectWithRange( object = setOfSchemesExample , pkModelRange ,  nSim = 13  , 
    summaryFunctionOverScenarios = "max" ,
    directory  = testDirectory1 , varianceMeasure = "sd" , objective = getExampleObjective() 
    , nCores = 1 )

 
  ## rank set of timePoints 
  timePoints          <-  getExampleSetOfTimePoints( 0:10 )
  testDirectory2      <-  file.path( tempdir() , "test2" )
  dir.create( testDirectory2 )
  rankObjectWithRange( object = timePoints , pkModelRange ,  nSim = 13  ,
    summaryFunctionOverScenarios = "max" ,  directory  = testDirectory2 , nGrid = 20 , 
    nSamplesAvCurve = 25 , nSubjectsPerScheme = 3 
    , nCores = 1 )
  
  # remark : use larger number of simulation in realistic context
 
 ## clean up directories 
  unlink( testDirectory1 , recursive = TRUE )
  unlink( testDirectory2 , recursive = TRUE )
 }
}
