% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external.R
\name{findrRNA}
\alias{findrRNA}
\title{Finding rRNA genes}
\usage{
findrRNA(genome.file, bacteria = TRUE, cpu = 1)
}
\arguments{
\item{genome.file}{A fasta-formatted file with the genome sequence(s).}

\item{bacteria}{Logical, the genome is either a bacteria (default) or an archea.}

\item{cpu}{Number of CPUs to use, default is 1.}
}
\value{
A \code{gff.table} (see \code{\link{readGFF}} for details) with one row for each detected
rRNA sequence.
}
\description{
Finding rRNA genes in genomic DNA using the barrnap software.
}
\details{
The external software barrnap is used to scan through a prokaryotic genome to detect the
rRNA genes (5S, 16S, 23S). This free software can be installed from https://github.com/tseemann/barrnap.
}
\note{
The barrnap software must be installed on the system for this function to work, i.e. the command
\samp{system("barrnap --help")} must be recognized as a valid command if you run it in the Console window.
}
\examples{
\dontrun{
# This example requires the external barrnap software
# Using a genome file in this package.
xpth <- file.path(path.package("microseq"),"extdata")
genome.file <- file.path(xpth,"small_genome.fasta")

# Searching for rRNA sequences, and inspecting
gff.tbl <- findrRNA(genome.file)
print(gff.table)

# Retrieving the sequences
genome <- readFasta(genome.file)
rRNA <- gff2fasta(gff.tbl, genome)
}

}
\seealso{
\code{\link{readGFF}}, \code{\link{gff2fasta}}.
}
\author{
Lars Snipen and Kristian Hovde Liland.
}
