% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cpp_sgl_fitpath}
\alias{cpp_sgl_fitpath}
\title{Computes a path solution for \eqn{\lambda} and fixed \eqn{\gamma} values}
\usage{
cpp_sgl_fitpath(
  X,
  Z,
  y,
  index,
  dummies,
  l1_frac,
  l21_frac,
  dummies_index,
  lambdas,
  gamma_w,
  innerIter,
  outerIter,
  thresh,
  outerThresh,
  gamma_solver,
  step,
  reset
)
}
\arguments{
\item{X}{(mat) matrix of covariates.}

\item{Z}{(mat) matrix of dummies.}

\item{y}{(vec) vector of response.}

\item{index}{(vec) vector indicating group membership of each covariate.}

\item{dummies}{(double) add dummy variables in a regression (dummies = 1) or not (dummies = 0).}

\item{l1_frac}{\eqn{\ell_1} norm peanlty factor for random or fixed effects (default value is zero which means \eqn{\alpha} is left unpenalized in \eqn{\ell_1 norm}).}

\item{l21_frac}{\eqn{\ell_{1,2}} norm peanlty factor for random or fixed effects (default value is zero which means \eqn{\alpha} is left unpenalized in \eqn{\ell_{1,2}} norm).}

\item{dummies_index}{vector indicating group membership of \eqn{\alpha}.}

\item{lambdas}{(vec) sequence of \eqn{\lambda} values for fitting.}

\item{gamma_w}{(double) sg-LASSO mixing parameter.}

\item{innerIter}{(int) max number of inner iterations.}

\item{outerIter}{(int) max number of outer iterations.}

\item{thresh}{(double) convergence threshold of inner loop.}

\item{outerThresh}{(double) convergence threshold of outer loop.}

\item{gamma_solver}{(double) solver parameter.}

\item{step}{(double) solver parameter.}

\item{reset}{(int) solver parameter.}
}
\description{
Computes a path solution for \eqn{\lambda} and fixed \eqn{\gamma} values
}
\keyword{internal}
