% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/modsel.R
\name{midas_r_ic_table}
\alias{midas_r_ic_table}
\title{Create a weight and lag selection table for MIDAS regression model}
\usage{
midas_r_ic_table(formula, data = NULL, start = NULL, table, IC = c("AIC",
  "BIC"), test = c("hAh_test"), Ofunction = "optim",
  weight_gradients = NULL, show_progress = TRUE, ...)
}
\arguments{
\item{formula}{the formula for MIDAS regression, the lag selection is performed for the last MIDAS lag term in the formula}

\item{data}{a list containing data with mixed frequencies}

\item{start}{the starting values for optimisation excluding the starting values for the last term}

\item{table}{an wls_table object, see \link{expand_weights_lags}}

\item{IC}{the names of information criteria which to compute}

\item{test}{the names of statistical tests to perform on restricted model, p-values are reported in the columns of model selection table}

\item{Ofunction}{see \link{midasr}}

\item{weight_gradients}{see \link{midas_r}}

\item{show_progress}{logical, TRUE to show progress bar, FALSE for silent evaluation}

\item{...}{additional parameters to optimisation function, see \link{midas_r}}
}
\value{
a \code{midas_r_ic_table} object which is the list with the following elements:

\item{table}{the table where each row contains calculated information criteria for both restricted and unrestricted MIDAS regression model with given lag structure}
\item{candlist}{the list containing fitted models}
\item{IC}{the argument IC}
}
\description{
Creates a weight and lag selection table for MIDAS regression model with given information criteria and minimum and maximum lags.
}
\details{
This function estimates models sequentially increasing the midas lag from \code{kmin} to \code{kmax} and varying the weights of the last term of the given formula
}
\examples{
data("USunempr")
data("USrealgdp")
y <- diff(log(USrealgdp))
x <- window(diff(USunempr),start=1949)
trend <- 1:length(y)


mwlr <- midas_r_ic_table(y~trend+fmls(x,12,12,nealmon),
                   table=list(x=list(weights=
                   as.list(c("nealmon","nealmon","nbeta")),
                   lags=list(0:4,0:5,0:6),
                   starts=list(rep(0,3),rep(0,3,),c(1,1,1,0)))))

mwlr
}
\author{
Virmantas Kvedaras, Vaidotas Zemlys
}

