% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midaslag.R
\name{mlsd}
\alias{mlsd}
\title{MIDAS lag structure with dates}
\usage{
mlsd(x, k, datey, ...)
}
\arguments{
\item{x}{a vector}

\item{k}{lags, a vector}

\item{datey}{low frequency dates}

\item{...}{further arguments used in fitting MIDAS regression}
}
\value{
a matrix containing the first differences and the lag k+1.
}
\description{
MIDAS lag structure with dates
}
\examples{
x <- c(1:144)
y <- c(1:12)
datey <- (y-1)*12+1

#msld and mls should give the same results

m1 <- mlsd(x, 0:5, datey)

m2 <- mls(x, 0:5, 12)

sum(abs(m1 - m2))

}
\author{
Virmantas Kvedaras, Vaidotas Zemlys-Balevičius
}
