% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipf3.R
\name{ipf3}
\alias{ipf3}
\title{Iterative Proportional Fitting Routine for the Indirect Estimation of Origin-Destination-Migrant Type Migration Flow Tables with Known Origin and Destination Margins.}
\usage{
ipf3(row_tot = NULL, col_tot = NULL, m = NULL, tol = 1e-05,
  maxit = 500, verbose = TRUE)
}
\arguments{
\item{row_tot}{Vector of origin totals to constrain the sum of the imputed cell rows.}

\item{col_tot}{Vector of destination totals to constrain the sum of the imputed cell columns.}

\item{m}{Array of auxiliary data. By default set to 1 for all origin-destination-migrant typologies combinations.}

\item{tol}{Numeric value for the tolerance level used in the parameter estimation.}

\item{maxit}{Numeric value for the maximum number of iterations used in the parameter estimation.}

\item{verbose}{Logical value to indicate the print the parameter estimates at each iteration. By default \code{FALSE}.}
}
\value{
Iterative Proportional Fitting routine set up in a similar manner to Agresti (2002, p.343). The arguments \code{row_tot} and \code{col_tot} take the row-table and column-table specific known margins.

The user must ensure that the row and column totals in each table sum to the same value. Care must also be taken to allow the dimension of the auxiliary matrix (\code{m}) to equal those provided in the row and column totals.

Returns a \code{list} object with
\item{mu }{Array of indirect estimates of origin-destination matrices by migrant characteristic}
\item{it }{Iteration count}
\item{tol }{Tolerance level at final iteration}
}
\description{
The \code{ipf3} function finds the maximum likelihood estimates for fitted values in the log-linear model:
\deqn{ \log y_{ijk} = \log \alpha_{i} + \log \beta_{j} + \log \lambda_{k} + \log \gamma_{ik} + \log \kappa_{jk} + \log m_{ijk} }
where \eqn{m_{ijk}} is a set of prior estimates for \eqn{y_{ijk}} and is no more complex than the matrices being fitted.
}
\examples{
## create row-table and column-table specific known margins.
dn <- LETTERS[1:4]
P1 <- matrix(c(1000, 100,  10,   0, 
               55,   555,  50,   5, 
               80,    40, 800 , 40, 
               20,    25,  20, 200), 
             nrow = 4, ncol = 4, byrow = TRUE, 
             dimnames = list(pob = dn, por = dn))
P2 <- matrix(c(950, 100,  60,   0, 
                80, 505,  75,   5, 
                90,  30, 800,  40, 
                40,  45,   0, 180), 
             nrow = 4, ncol = 4, byrow = TRUE, 
             dimnames = list(pob = dn, por = dn))
# display with row and col totals
addmargins(P1)
addmargins(P2)

# run ipf
y <- ipf3(row_tot = t(P1), col_tot = P2)
# display with row, col and table totals
round(addmargins(y$mu), 1)
# origin-destination flow table
round(sum_od(y$mu), 1)

## with alternative offset term
dis <- array(c(1, 2, 3, 4, 2, 1, 5, 6, 3, 4, 1, 7, 4, 6, 7, 1), c(4, 4, 4))
y <- ipf3(row_tot = t(P1), col_tot = P2, m = dis)
# display with row, col and table totals
round(addmargins(y$mu), 1)
# origin-destination flow table
round(sum_od(y$mu), 1)
}
\references{
Abel, G. J. (2013). Estimating Global Migration Flow Tables Using Place of Birth. \emph{Demographic Research} 28, (18) 505-546

Agresti, A. (2002). \emph{Categorical Data Analysis} 2nd edition. Wiley.
}
\seealso{
\code{\link{ipf3_qi}}, \code{\link{ipf2}}
}
\author{
Guy J. Abel
}
