% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip_to.R
\name{transform}
\alias{transform}
\alias{to_mode1}
\alias{to_mode2}
\alias{to_main_component}
\alias{to_subgraph}
\alias{to_ties}
\alias{to_blocks}
\title{Tools for transforming networks, graphs, and matrices}
\usage{
to_mode1(object)

to_mode2(object)

to_main_component(object)

to_subgraph(object, ...)

to_ties(object)

to_blocks(object, membership, FUN = mean)
}
\arguments{
\item{object}{An object of a migraph-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{...}{Arguments passed on to dplyr::filter}

\item{membership}{A vector of partition memberships}

\item{FUN}{A function for summarising block content.
By default \code{mean}.
Other recommended options include \code{median}, \code{sum},
\code{min} or \code{max}.}
}
\description{
These functions offer tools for transforming migraph-consistent objects
(matrices, igraph, tidygraph, or network objects).
Transforming means that the returned object may have different dimensions
than the original object.
}
\details{
Since some modifications are easier to implement for some objects than others,
here are the currently implemented modifications:\tabular{lccccc}{
   to_ \tab edgelists \tab matrices \tab igraph \tab tidygraph \tab network \cr
   mode1 \tab  \tab X \tab X \tab X \tab  \cr
   mode2 \tab  \tab X \tab X \tab X \tab  \cr
   main_component \tab  \tab  \tab X \tab X \tab X \cr
   subgraph \tab X \tab X \tab X \tab X \tab X \cr
   ties \tab X \tab X \tab X \tab X \tab X \cr
   blocks \tab X \tab X \tab X \tab X \tab X \cr
}


Note that \code{to_subgraph()} returns a 'tidygraph' object,
\code{to_ties()} returns an 'igraph' object,
and \code{to_blocks()} returns a 'matrix' object.
}
\section{Functions}{
\itemize{
\item \code{to_mode1}: Results in a weighted one-mode object
that retains the row nodes from a two-mode object,
and weights the ties between them on the basis of
their joint ties to nodes in the second mode (columns)

\item \code{to_mode2}: Results in a weighted one-mode object
that retains the column nodes from a two-mode object,
and weights the ties between them on the basis of
their joint ties to nodes in the first mode (rows).

\item \code{to_main_component}: Returns an object that includes only the main component
without any smaller components or isolates

\item \code{to_subgraph}: Returns a network subgraph filtered
on the basis of some node-related logical statement.

\item \code{to_ties}: Returns a matrix (named if possible)
where the edges are the nodes

\item \code{to_blocks}: Returns a reduced graph from a given
partition membership vector
}}

\examples{
autographr(ison_southern_women) /
(autographr(to_mode1(ison_southern_women)) |
autographr(to_mode2(ison_southern_women)))
autographr(ison_adolescents) +  
autographr(to_ties(ison_adolescents))
(adolblock <- to_blocks(ison_adolescents, 
  node_regular_equivalence(ison_adolescents, k = 3)))
autographr(adolblock)
}
\seealso{
Other manipulations: 
\code{\link{add}},
\code{\link{as}()},
\code{\link{grab}},
\code{\link{reformat}}
}
\concept{manipulations}
