% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip_grab.R
\name{grab}
\alias{grab}
\alias{node_names}
\alias{node_mode}
\alias{node_attribute}
\alias{tie_attribute}
\alias{tie_weights}
\alias{tie_signs}
\alias{graph_nodes}
\alias{graph_ties}
\alias{graph_dims}
\alias{graph_node_attributes}
\alias{graph_tie_attributes}
\title{Grab various node or edge attributes from a network}
\usage{
node_names(object)

node_mode(object)

node_attribute(object, attribute)

tie_attribute(object, attribute)

tie_weights(object)

tie_signs(object)

graph_nodes(object)

graph_ties(object)

graph_dims(object)

graph_node_attributes(object)

graph_tie_attributes(object)
}
\arguments{
\item{object}{An object of a migraph-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{attribute}{Character string naming an attribute in the object.}
}
\description{
These functions operate to help extract certain attributes
from given network data.
They are also useful as helpers within other functions.

\verb{graph_*()} functions always relate to the overall graph or network,
usually returning a scalar.
\verb{node_*()} and \verb{tie_*()} always return vectors the same length
as the number of nodes or edges in the network, respectively.
}
\section{Functions}{
\itemize{
\item \code{node_names()}: Extracts the names of the nodes in a network.

\item \code{node_mode()}: Extracts the mode of the nodes in a network.

\item \code{node_attribute()}: Extracts an attribute's values for the nodes in a network.

\item \code{tie_attribute()}: Extracts an attribute's values for the edges in a network.

\item \code{tie_weights()}: Extracts the weights of the edges in a network.

\item \code{tie_signs()}: Extracts the signs of the edges in a network.

\item \code{graph_nodes()}: Returns the total number of nodes (of any mode) in a network.

\item \code{graph_ties()}: Returns the number of edges in a network.

\item \code{graph_dims()}: Returns the dimensions of a network in a vector
as long as the number of modes in the network.

\item \code{graph_node_attributes()}: Returns a vector of nodal attributes in a network

\item \code{graph_tie_attributes()}: Returns a vector of edge attributes in a network

}}
\examples{
node_names(mpn_elite_usa_advice)
node_mode(mpn_elite_usa_advice)
node_attribute(mpn_elite_mex, "full_name")
tie_attribute(ison_algebra, "task_tie")
tie_weights(to_mode1(ison_southern_women))
tie_signs(ison_marvel_relationships)
graph_nodes(ison_southern_women)
graph_ties(ison_southern_women)
graph_dims(ison_southern_women)
graph_dims(to_mode1(ison_southern_women))
graph_node_attributes(mpn_elite_mex)
graph_tie_attributes(mpn_elite_mex)
}
\seealso{
Other manipulations: 
\code{\link{add}},
\code{\link{as}()},
\code{\link{reformat}},
\code{\link{transform}()}
}
\concept{manipulations}
