#' Multimodal (3) Bristol protest events, 1990-2002
#'
#' A multimodal (3) matrix containing individuals affiliations to civic organizations
#' in Bristol and their participation in major protest and civic events between 1990-2002,
#' and the involvement of the organizations in these events.
#'
#' @docType data
#' @keywords datasets
#' @name mpn_bristol
#' @usage data(mpn_bristol)
#' @format A matrix with 264 rows and columns. Node IDs are prefaced with a type identifier:
#' \describe{
#'   \item{1_}{150 Individuals, anonymised}
#'   \item{2_}{97 Bristol Civic Organizations}
#'   \item{3_}{17 Major Protest and Civic Events in Bristol, 1990-2002}
#' }
#' @source Knoke, David, Mario Diani, James Hollway, and Dimitris C Christopoulos. 2021.
#' \href{https://www.cambridge.org/core/books/multimodal-political-networks/43EE8C192A1B0DCD65B4D9B9A7842128}{\emph{Multimodal Political Networks}}.
#' Cambridge University Press. Cambridge University Press.
"mpn_bristol"