% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blockmodel.R
\name{blockmodel}
\alias{blockmodel}
\alias{cluster_structural_equivalence}
\alias{cluster_regular_equivalence}
\alias{blockmodel_concor}
\alias{print.blockmodel}
\alias{reduce_graph}
\title{Blockmodelling}
\source{
\url{https://github.com/aslez/concoR}
}
\usage{
cluster_structural_equivalence(mat)

cluster_regular_equivalence(object)

blockmodel(object, clusters)

blockmodel_concor(
  object,
  p = 1,
  cutoff = 0.999,
  max.iter = 25,
  block.content = "density"
)

\method{print}{blockmodel}(x, ...)

reduce_graph(blockmodel, block_labels = NULL)
}
\arguments{
\item{mat}{a (long) matrix of ties}

\item{object}{a migraph-consistent object}

\item{clusters}{the vector of cluster membership for the blockmodel}

\item{p}{An integer representing the desired number of partitions.}

\item{cutoff}{A value between 0 and 1 used to determine convergence.}

\item{max.iter}{An integer representing the maximum number of iterations.}

\item{block.content}{A string indicating which method to use for
calculating block content.
Options are: "density", "sum", "meanrowsum", "meancolsum",
"median", "min", "max".}

\item{x}{An object of class "blockmodel"}

\item{...}{Additional arguments passed to generic print method}

\item{blockmodel}{a blockmodel object}

\item{block_labels}{A character vector manually providing labels
for the blocks in the blockmodel}
}
\description{
Blockmodelling
}
\examples{
mex_concor <- blockmodel_concor(mpn_elite_mex)
mex_concor
plot(mex_concor)
usa_concor <- blockmodel_concor(mpn_elite_usa_advice)
usa_concor
plot(usa_concor)
res <- cluster_structural_equivalence(node_tie_census(mpn_elite_mex))
res <- cluster_regular_equivalence(node_triad_census(mpn_elite_mex))
}
\references{
Breiger, R.L., Boorman, S.A., and Arabie, P.  1975.
An Algorithm for Clustering Relational Data with Applications to
Social Network Analysis and Comparison with Multidimensional Scaling.
\emph{Journal of Mathematical Psychology}, 12: 328--383.
}
