% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.R
\name{generate}
\alias{generate}
\alias{generate_random}
\alias{generate_smallworld}
\alias{generate_scalefree}
\title{Create networks from particular probabilities}
\usage{
generate_random(n, p, m)

generate_smallworld(n, p = 0.05)

generate_scalefree(n, p = 1)
}
\arguments{
\item{n}{Integer of length 1 or 2.}

\item{p}{Number of edges in the network over the number of edges possible}

\item{m}{Number of edges in the network}
}
\description{
Create networks from particular probabilities
}
\details{
Creates a random network.
If \code{length(n)==1}, then a one-mode network will be returned,
equivalent to an Erdös-Renyi graph.
If \code{length(n)==1}, then a two-mode network will be returned.
The first number is the number of nodes in the first nodeset (rows),
and the second number becomes the number of nodes in the second nodeset (columns).
}
\examples{
er1 <- autographr(generate_random(12, 0.4))
er2 <- autographr(generate_random(c(6, 6), 0.4))
grid.arrange(er1, er2, ncol = 2)
sw1 <- autographr(generate_smallworld(12, 0.025))
sw2 <- autographr(generate_smallworld(12, 0.25))
grid.arrange(sw1, sw2, ncol = 2)
sf1 <- autographr(generate_scalefree(12, 0.25))
sf2 <- autographr(generate_scalefree(12, 1.25))
grid.arrange(sf1, sf2, ncol = 2)
}
\seealso{
Other creation: 
\code{\link{create}}
}
\concept{creation}
