% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/member_core.R
\name{core}
\alias{core}
\alias{node_core}
\alias{node_coreness}
\title{Core-periphery clustering algorithms}
\usage{
node_core(.data, method = c("degree", "eigenvector"))

node_coreness(.data)
}
\arguments{
\item{.data}{An object of a \code{{manynet}}-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{method}{Which method to use to identify cores and periphery.
By default this is "degree",
which relies on the heuristic that high degree nodes are more likely to be in the core.
An alternative is "eigenvector", which instead begins with high eigenvector nodes.
Other methods, such as a genetic algorithm, CONCOR, and Rombach-Porter,
can be added if there is interest.}
}
\description{
This function is used to identify which nodes should belong to the core,
and which to the periphery.
It seeks to minimize the following quantity:
\deqn{Z(S_1) = \sum_{(i<j)\in S_1} \textbf{I}_{\{A_{ij}=0\}} + \sum_{(i<j)\notin S_1} \textbf{I}_{\{A_{ij}=1\}}}
where nodes \eqn{\{i,j,...,n\}} are ordered in descending degree,
\eqn{A} is the adjacency matrix,
and the indicator function is 1 if the predicate is true or 0 otherwise.
Note that minimising this quantity maximises density in the core block
and minimises density in the periphery block;
it ignores ties between these blocks.
}
\section{Functions}{
\itemize{
\item \code{node_coreness()}: Returns k-cores

}}
\examples{
#mpn_elite_usa_advice \%>\% as_tidygraph \%>\% 
#   mutate(corep = node_core(mpn_elite_usa_advice)) \%>\% 
#   autographr(node_color = "corep")
network_core(mpn_elite_usa_advice)
node_coreness(ison_adolescents)
}
\references{
Borgatti, Stephen P., & Everett, Martin G. 1999.
Models of core /periphery structures.
\emph{Social Networks}, 21, 375–395.
\doi{10.1016/S0378-8733(99)00019-2}

Lip, Sean Z. W. 2011.
“A Fast Algorithm for the Discrete Core/Periphery Bipartitioning Problem.”
\doi{10.48550/arXiv.1102.5511}
}
\seealso{
Other memberships: 
\code{\link{community}},
\code{\link{components}()},
\code{\link{equivalence}}
}
\concept{memberships}
