% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/association.test.logistic.r
\name{association.test.logistic}
\alias{association.test.logistic}
\title{Mixed logistic regression for GWAS}
\usage{
association.test.logistic(
  x,
  Y = x@ped$pheno,
  X = matrix(1, nrow(x)),
  K,
  beg = 1,
  end = ncol(x),
  algorithm = c("offset", "amle"),
  eigenK,
  p = 0,
  ...
)
}
\arguments{
\item{x}{a bedmatrix}

\item{Y}{phenotype vector. Default is column \code{pheno} of \code{x@ped}}

\item{X}{A matrix of covariates (defaults to a column of ones for the intercept)}

\item{K}{A genetic relationship matrix (or a list of such matrices)}

\item{beg}{Index of the first SNP tested for association}

\item{end}{Index of the last SNP tested for association}

\item{algorithm}{Algorithm to use}

\item{eigenK}{eigen decomposition of K (only if \code{p} > 0)}

\item{p}{Number of principal components to include in the model}

\item{...}{Additional parameter for \code{gaston::logistic.mm.aireml}}
}
\value{
A data frame giving for each SNP the association statistics.
}
\description{
Mixed logistic regression for GWAS
}
\details{
Tests the association between the phenotype and requested SNPs in \code{x}.
The phenotype \code{Y} is a binary trait. A Wald test is performed using an approximate
method defined by the parameter \code{algorithm}. All other arguments are as in 
\code{gaston::association.test}.
}
\examples{
data(TTN)
x <- as.bed.matrix(TTN.gen, TTN.fam, TTN.bim)
## Simulation data ##
set.seed(1)
# some covariables
X <- cbind(1, runif(nrow(x)))
# A random GRM
ran <- random.pm( nrow(x))
# random effects (tau = 1)
omega <- lmm.simu(1, 0, eigenK=ran$eigen)$omega
# linear term of the model
lin <- X \%*\% c(0.1,-0.2) + omega
# vector of probabilitues
pi <- 1/(1+exp( -lin ))
# vector of binary phenotypes
y <- rbinom(nrow(x), 1, pi)
# testing association with 1) the score test, 2) the offset algorithm, 3) the 'amle' algorithm
a1 <- association.test(x, y, X, K = ran$K, method = "lmm", response = "bin")
a2 <- association.test.logistic(x, y, X, K = ran$K, algorithm = "offset")
a3 <- association.test.logistic(x, y, X, K = ran$K, algorithm = "amle")

}
\seealso{
\code{\link[gaston]{association.test}}
}
