% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_string_generation.R
\name{extend_length}
\alias{extend_length}
\title{\code{extend_length}}
\usage{
extend_length(
  overlaps,
  position_reference,
  genome_position,
  prev,
  after,
  ori_string_start,
  ori_string_end,
  ori_snp_pos,
  genome_max
)
}
\arguments{
\item{overlaps}{Overlappings}

\item{position_reference}{the mapping of position
in SNP matrix to reference genome}

\item{genome_position}{the position of the SNP in the reference genome}

\item{prev}{number of bases before the SNP included in the search string}

\item{after}{number of bases after the SNP included in the search string}

\item{ori_string_start}{original starting point of search string}

\item{ori_string_end}{original ending point of the search string}

\item{ori_snp_pos}{original SNP position in search string}

\item{genome_max}{length of the reference genome}
}
\value{
a list containing the new `string_start`,
`string_end`, `snp_pos`, `snps_in_string`.
}
\description{
\code{extend_length} extend the search sequence such that
there will always be (prev) bases before the SNPs and
(after) bases after the SNPs.
}
