% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mindr.R
\name{mm2md}
\alias{mm2md}
\title{Convert a mind map (.mm) into markdown headers.}
\usage{
mm2md(pattern = "*.mm$", path = ".", savefile = TRUE, savefilename = "mindr.md", 
    backup = TRUE)
}
\arguments{
\item{pattern}{an optional regular expression for filtering the input files. See \code{help(dir)}.}

\item{path}{character. The path of the folder which contains the input file(s).}

\item{savefile}{logical. Whether to save the output as a markdown file.}

\item{savefilename}{character. Valid when savefile == TRUE.}

\item{backup}{logical. Whether the existing target file, if any, should be saved as backups.}
}
\value{
a vector of strings showing outline of a markdown document or book.
}
\description{
Convert a mind map (.mm) into markdown headers.
}
\examples{
path <- system.file("examples/mm", package = "mindr")
mm2md(path = path)
}
