% Generated by roxygen2 (4.0.1): do not edit by hand
\name{plot.pkgDepGraph}
\alias{plot.pkgDepGraph}
\title{Plots a package dependency graph.}
\usage{
\method{plot}{pkgDepGraph}(x, pkgsToHighlight,
  main = "Package dependency graph", legendPosVertex = c(-1, -1),
  legendPosEdge = c(1, -1), shape = "circle", vertex.size = 8, cex = 1,
  ...)
}
\arguments{
\item{x}{pkgDepGraph object}

\item{pkgsToHighlight}{Optional character vector with names of package to hightlight. If missing, defaults to packages used in original call to \code{\link{makeDepGraph}}}

\item{main}{Title of plot}

\item{legendPosVertex}{Numeric vector of length 2, indicating (x, y) position of vertex legend. Both values should be in the range [-1; 1].  If NULL, the vertex legend is not displayed.}

\item{legendPosEdge}{Numeric vector of length 2, indicating (x, y) position of edge legend. Both values should be in the range [-1; 1].  If NULL, the edge legend is not displayed.}

\item{shape}{Shape of edge.  See \code{\link[igraph]{igraph.plotting}}. Could be "none", "circle", "square", ...}

\item{vertex.size}{Size of vertex shape. See \code{\link[igraph]{igraph.plotting}}}

\item{cex}{Vertex label size.}

\item{...}{Ignored}
}
\description{
Plots a package dependency graph.
}
\examples{
tags <- "chron"

# Plot using defaults
dg <- makeDepGraph(tags, includeBasePkgs=FALSE, suggests=TRUE, enhances=TRUE)

set.seed(42); 
plot(dg)

# Move edge legend to top left
set.seed(42); 
plot(dg, legendPosEdge=c(-1, 1))

# Change font size and shape size
set.seed(42); 
plot(dg, legendPosEdge=c(-1, 1), vertex.size=20,  cex=0.5)


# Move vertex legend to top right
set.seed(42); 
plot(dg, legendPosEdge=c(-1, 1), legendPosVertex=c(1, 1), vertex.size=20,  cex=0.5)

}
\seealso{
\code{\link{makeDepGraph}}
}

