% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github-functions.R
\name{addPackageListingGithub}
\alias{addPackageListingGithub}
\title{Add DESCRIPTION information from package on github.}
\usage{
addPackageListingGithub(
  pdb = pkgAvail(),
  repo,
  username = NULL,
  branch = "main"
)
}
\arguments{
\item{pdb}{Package database, usually the result of \code{\link[=pkgAvail]{pkgAvail()}} or
\code{\link[=available.packages]{available.packages()}}}

\item{repo}{Character vector. Name of repository on github, e.g.
\code{"andrie/rrd"}}

\item{username}{Optional character vector. Name of repository on github, e.g.
\code{"andrie/rrd"}}

\item{branch}{name of branch, defaults to \code{"main"}}
}
\description{
Downloads the DESCRIPTION file from a package on github, parses the fields
and adds (or replaces) a row in the available package database.
}
\examples{
# Create package database
pdb <- cranJuly2014

if (interactive()) {
  pdb <- pkgAvail(repos = c(CRAN = "https://cloud.r-project.org"))

  # Overwrite pdb with development version of miniCRAN at github
  newpdb <- addPackageListingGithub(pdb = pdb, "andrie/miniCRAN")
  newpdb["miniCRAN", ]

  # Add package from github that's not currently on CRAN
  newpdb <- addPackageListingGithub(pdb = pdb, repo = "tidyverse/ggplot2", branch = "main")
  newpdb["ggplot2", ]

  set.seed(1)
  plot(makeDepGraph("ggplot2", availPkgs = newpdb, suggests = TRUE))
}
}
\concept{github functions}
