% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimalistGODB.R
\name{parseGOBASIC}
\alias{parseGOBASIC}
\title{parseGOBASIC}
\usage{
parseGOBASIC(gobasic, verbose = FALSE)
}
\arguments{
\item{gobasic}{character string path name to downloaded go-basic.obo}

\item{verbose}{Boolean if TRUE print out some diagnostic info}
}
\value{
returns a list whose components are c("m",  "bp", "mf", "cc")
}
\description{
parse go-basic.obo
}
\details{
download go-basic.obo from https://geneontology.org/docs/download-ontology/
}
\examples{
\dontrun{
# replace my path name for gobasic with your own!!
# this was obtained from the download sites listed in 'details' section
GO<-parseGOBASIC("~/go-basic.obo",verbose=FALSE)
# GO$bp[1:5,]
#            GO           NAME                               ONTOLOGY            
# GO:0000001 "GO:0000001" "mitochondrion inheritance"        "biological_process"
# GO:0000002 "GO:0000002" "mitochondrial genome maintenance" "biological_process"
# GO:0000011 "GO:0000011" "vacuole inheritance"              "biological_process"
# GO:0000012 "GO:0000012" "single strand break repair"       "biological_process"
# GO:0000017 "GO:0000017" "alpha-glucoside transport"        "biological_process"
}

# here is a small example that you can run
f<-system.file("extdata","go-basic.small.obo",package="minimalistGODB")
GOsmall<-parseGOBASIC(f)

}
