% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stoichiometricMatrix.R
\name{stoichiometricMatrix}
\alias{stoichiometricMatrix}
\title{Return the stoichiometric matrix for a set of stoichiometric reactions}
\usage{
stoichiometricMatrix(reactionList)
}
\arguments{
\item{reactionList}{A set of stoichiometric reaction with the following format: 

\code{"H2O[c] + Urea-1-carboxylate[c] <=> 2 CO2[c] + 2 NH3[c]"} 

Where arrows and plus signs are surrounded by a "space character".
It is also expected that stoichiometry coefficients are surrounded by spaces, (nothe the "2" before the CO2[c] or the NH3[c]).
It also expects arrows to be in the form "\code{=>}" or "\code{<=>}". 
Meaning that arrows like "\code{==>}", "\code{<==>}", "\code{-->}" or "\code{->}" will not be parsed and will lead to errors.}
}
\value{
The stoichiometric matrix for a given set of stoichiometric reactions
}
\description{
A set of stoichiometric reactions are often represented in a more compact form called the stoichiometry matrix. If a reaction network has n reactions and m participating metabolites then the stoichiometry matrix will have correspondingly m rows and n columns.
}
\examples{
# Loading data
glycolysis <- read.csv2(system.file("extdata", "glycolysisKEGG.csv", package = "minval"))

# Removing stoichiometric reactions without valid syntax
glycolysis <- mapReactions(
                           reactionList = isValidSyntax(glycolysis$REACTION),
                           referenceData = glycolysis,
                           by = "bool"
                           )
# Building the Stoichiometric-Matrix 
stoichiometricMatrix(glycolysis$REACTION)

}
\author{
Daniel Camilo Osorio <dcosorioh@unal.edu.co>
}
\keyword{Matrix}
\keyword{Metabolic}
\keyword{Reactions}
\keyword{Reconstruction}
\keyword{Stoichiometric}

