context("use of seed")

skip('seeduse tests mipred.cv')

cll <- readRDS("CLL_BMJ.rds")

cll_bin<-cll

cll_bin$srv5y_s[cll_bin$srv5y>12] <- 0  # Apply an administrative censorship at t=84 months
cll_bin$srv5y[cll_bin$srv5y>12]  <- 12

cll_bin$Status[cll_bin$srv5y_s==1]<- 1  # Define the "Status" variable
cll_bin$Status[cll_bin$srv5y_s==0] <- 0  # Ss numeric -> 1:Dead, 0:Alive

cll_bin$Censor <- NULL
cll_bin$srv5y <- NULL
cll_bin$srv5y_s <- NULL

seeds <- c(7350, 5880, 2571, 3887, 9745, 5608, 3468, 2711, 3448, 4676,
  1627, 5087, 6479, 3901, 1037, 6622, 4832, 3382, 8515, 268, 3210,
  5944, 3380, 3646, 9188, 2750, 7987, 466, 2981, 136, 5134, 8476,
  5618, 8948, 1590, 5281, 2551, 2052, 1444, 8688, 1691, 6398, 4728,
  8267, 5274, 4154, 982, 7540, 3081, 5286, 6405, 1238, 5589, 8221,
  6026, 1922, 7651, 3100, 4341, 2134, 9685, 4524, 9750, 7618, 8211,
  2438, 824, 6982, 6548, 9743, 4302, 9038, 185, 4418, 1306, 6643,
  9865, 3436, 6151, 9647, 4261, 8109, 7573, 127, 571, 4545, 7245,
  4764, 5038, 9037, 6085, 1459, 5124, 9463, 942, 2241, 6492, 3190,
  8229, 7099)

output <- list(pred = structure(c(0.318476658047352, 0.278277048107985,
  0.289117615852041, 0.211135171149873, 0.249522308432969, 0.389771192560319,
  0.344979895206721, 0.216660595127165, 0.250288239652983, 0.269703726833673,
  0.340352700823184, 0.338771774439977, 0.217077885020672, 0.342369169017627,
  0.268697134810221, 0.278026334858864, 0.214169049820016, 0.215308412975576,
  0.271178672807153, 0.266674919110185, 0.341249667738499, 0.215567971662233,
  0.261426874822799, 0.350285378901966, 0.256780283310259, 0.344710099594545,
  0.213446287452638, 0.253511703583354, 0.249119937145298, 0.227954602444087,
  0.34707266046736, 0.382455456070599, 0.338149661021268, 0.213137076693493,
  0.215204653018046, 0.259939748511985, 0.237919046938709, 0.330902467090568,
  0.274713617631881, 0.364255856021758, 0.209961031699854, 0.206862493588199,
  0.251859201242077, 0.259085776797963, 0.268234912149884, 0.367849258607926,
  0.339525745521949, 0.258335788863199, 0.272627528567793, 0.389771192560319,
  0.333901248262856, 0.341594958243188, 0.335405709883753, 0.207223225120957,
  0.250847437064224, 0.450846610364685, 0.212519635387817, 0.263667844831566,
  0.339767951772685, 0.218542971159667, 0.253976957062959, 0.255511417848828,
  0.259013895750118, 0.364403702004156, 0.415594443312706, 0.278790858499278,
  0.269784819819288, 0.208131361926957, 0.264254791434256, 0.201317614129306,
  0.247686439738609, 0.378667030244566, 0.268455804092921, 0.253279288017807,
  0.391608047501748, 0.278143940261787, 0.340628569161037, 0.338906170378138,
  0.262795790658015, 0.276553228857715, 0.251945633251127, 0.33273702565185,
  0.30674508188831, 0.25240898444152, 0.328467980666689, 0.211698413405678,
  0.211749671706206, 0.267491854421763, 0.227954602444087, 0.25584359521477,
  0.217182298207491, 0.274774815388889, 0.345751468307675, 0.370532544078995,
  0.21733898601965, 0.197010229977143, 0.242402572755818, 0.274287406495075,
  0.344571362758253, 0.264293421262534, 0.334594527617378, 0.27957784513664,
  0.267672427515245, 0.208386092619483, 0.356399864612504, 0.274287406495075,
  0.275325976079974, 0.279821738707483, 0.206668767939497, 0.335816599981964,
  0.339870191649064, 0.263538862943414, 0.33424287599314, 0.270348735365247,
  0.255376092823931, 0.327758176036003, 0.322726854491937, 0.270390287474222,
  0.337806066294044, 0.310851231286767, 0.274160351736859, 0.212314112058644,
  0.328608809086156, 0.340008017558864, 0.17539896042577, 0.285956156147657,
  0.253362469340261, 0.331310590641769, 0.337188027181408, 0.375055287027818,
  0.394216618067206, 0.317693182144981, 0.357138743661345, 0.211391054209229,
  0.311689606998716, 0.38687034141343, 0.346592920954192, 0.366952565854258,
  0.269482406771498, 0.343185454321166, 0.216504261100954, 0.219699097822628,
  0.335748101015052, 0.305106657868705, 0.263715622314504, 0.316804207297008,
  0.353749388639698, 0.340008017558864, 0.280473791901386, 0.297111188723024,
  0.301833519982424, 0.370532544078995, 0.248241781684749, 0.369645383307968,
  0.215983737384082, 0.271603785352225, 0.263554125494824, 0.326060303359362,
  0.406409587814761, 0.269482406771498, 0.337119390462037, 0.394427855656135,
  0.207879908211654, 0.385041644674155, 0.251179208870145, 0.215152786650363,
  0.210419905758043, 0.256721674595334, 0.265921108179742, 0.347977994890574,
  0.344164144859683, 0.3361591983996, 0.210879515003454, 0.295369406219235,
  0.257836736788262, 0.192074022040805, 0.252756868035715, 0.157226288152208,
  0.315010057146063, 0.213394729636435, 0.217025692033945, 0.260194544867895,
  0.256077556900082, 0.317512884674265, 0.311678329560489, 0.392527631099592,
  0.343185454321166, 0.338218400476129, 0.213497854344633, 0.243947046402045,
  0.21744348991454, 0.419347425780873, 0.25625312021214, 0.344432652410444,
  0.295369406219235, 0.112178247829054, 0.212725303937648, 0.178242569199466,
  0.284433303290058, 0.261313779005266, 0.278801427961955, 0.330183874078827,
  0.338837362710635, 0.359947537352971, 0.248890205453823, 0.342369169017627,
  0.334447936149812, 0.343094466446735, 0.22582160247482, 0.413721588194801,
  0.265630466640554, 0.360836869521144, 0.247000329408915, 0.319187328745714,
  0.217077885020672, 0.33335500640596, 0.302647161537581, 0.270753978314213,
  0.215855977710551, 0.257895511741712, 0.254559315321942, 0.30933703001785,
  0.333605854179501, 0.218647892242237, 0.360836869521144, 0.314178153060384,
  0.213497854344633, 0.256663074637884, 0.318338113002256, 0.289911213346933,
  0.217315306191547, 0.244098634409356, 0.251251664929358, 0.264075692516856,
  0.338287146762276, 0.221176877149173, 0.286624778118167, 0.248603240103813,
  0.268154333718955, 0.241501289765835, 0.367088661282974, 0.334649316185711,
  0.272627528567793, 0.322678244424582, 0.262049026548806, 0.246088103294615,
  0.397136874239036, 0.343106313990544, 0.311689606998716, 0.236141687080068,
  0.288194333606971, 0.201317614129306, 0.40553851192263, 0.21180093908323,
  0.425950256916545, 0.190292395318614, 0.21484177900345, 0.352867880806271,
  0.240406750709935, 0.328797889388855, 0.340766543855735, 0.203066698060366,
  0.251772022058241, 0.229884959274666, 0.324227093749549, 0.30674508188831,
  0.332672832991699, 0.236901734741315, 0.272698848953472, 0.328479575694349,
  0.265054523928038, 0.417482523170427, 0.366192748576653, 0.392375418730081,
  0.239702921149871, 0.339456876654057, 0.21401402242476, 0.412798833791985,
  0.218280827146825, 0.256545900998611, 0.192074022040805, 0.332059476027492,
  0.427825204406016, 0.256897527009326, 0.2109817502325, 0.255259304966803,
  0.32873011349675, 0.35911579829215, 0.311815302017182, 0.217077885020672,
  0.343808784137928, 0.312643801720051, 0.327758176036003, 0.248029973929245,
  0.196439440818991, 0.245120120482969, 0.27501969107536, 0.234701025058472,
  0.203315322846204, 0.270632713866559, 0.268071655398011, 0.215204653018046,
  0.358228330552611, 0.346592920954192, 0.406255592376625, 0.208335433341549,
  0.346516080435515, 0.276676139830661, 0.219435956440444, 0.345126468848312,
  0.202024948575796, 0.252930928770697, 0.234263316651839, 0.359812584318434,
  0.20991009107477, 0.251251664929358, 0.215567971662233, 0.24642954724081,
  0.281904375613917, 0.376853276354959, 0.293098450613946, 0.456377726748954,
  0.339250310805845, 0.326767722478133, 0.219173041705143, 0.207021477299952,
  0.335816599981964, 0.291553092261275, 0.368746866189144, 0.253802421032916,
  0.431824055759885, 0.207122333063204, 0.25310506877133, 0.251772022058241,
  0.200595598166473, 0.3372566707653, 0.247686439738609, 0.338039149740225,
  0.329460567835899, 0.190978064397727, 0.29138129448144, 0.274224340522117,
  0.263543922836054, 0.360836869521144, 0.216504261100954, 0.246543632627378,
  0.28899722813945, 0.278709033032818, 0.338906170378138, 0.252351034686709,
  0.257895511741712, 0.340352700823184, 0.236204975740026, 0.261426874822799,
  0.331037702447789, 0.326908672773575, 0.338903013505522, 0.212673873185826,
  0.256019053327452, 0.340697553133123, 0.335748101015052, 0.214531098038895,
  0.34131871238375, 0.387021778451727, 0.249809981968818, 0.249522308432969,
  0.311815302017182, 0.335405709883753, 0.346516080435515, 0.34145682186233,
  0.211135171149873, 0.389771192560319, 0.250385992353037, 0.357138743661345,
  0.332741018833129, 0.30120725134092, 0.258483741908431, 0.217391233431817,
  0.340145870561065, 0.256780283310259, 0.276860569522871, 0.294699737806979,
  0.259939748511985, 0.245461256608586, 0.416531789486695, 0.212519635387817,
  0.328479575694349, 0.246886101938155, 0.247629215079984, 0.306049660516686,
  0.33554264558689, 0.33445241182978, 0.213085573332747, 0.343393170994405,
  0.231253870113548, 0.256663074637884, 0.21401402242476, 0.409264279707781,
  0.289911213346933, 0.117696977996457, 0.253315922220202, 0.212828192669884,
  0.324238611355054, 0.341180629825638, 0.277419296951917, 0.273613507139854,
  0.339870191649064, 0.146334438641954, 0.312696685047393, 0.331026061633763,
  0.213962364776975, 0.207425118122162, 0.376097472157549, 0.294699737806979,
  0.215308412975576, 0.21375582494019, 0.338906170378138, 0.255609773839351,
  0.314998714549146, 0.306049660516686, 0.448718131096954, 0.432770899723909,
  0.21484177900345, 0.244659327655866, 0.214738182383265, 0.309389605774661,
  0.240299789767643, 0.210573027151856, 0.246771909980999, 0.344779477940063,
  0.256780283310259, 0.273308408687929, 0.284264017471004, 0.247743673266817,
  0.336570544094479, 0.375042966135977, 0.268186614133567, 0.373385493712669,
  0.21241685557057, 0.404549471175938, 0.368883239311829, 0.215516041777424,
  0.208588820482789, 0.215203660899757, 0.250732022874761, 0.275826023204938,
  0.333736102063782, 0.338094215760186, 0.216556363370973, 0.201223437443438,
  0.141948507591184, 0.325213071826165, 0.421383093473221, 0.34818707457714,
  0.269703726833673, 0.322550222867606, 0.252872899717432, 0.315010057146063,
  0.3797255347008, 0.23974777002349, 0.265168657556937, 0.209096275417937,
  0.204711810561176, 0.409996120305073, 0.310851231286767, 0.355369129385172,
  0.429715109059438, 0.251945633251127, 0.394229171508779, 0.253315922220202,
  0.341111598647436, 0.403620436524339, 0.206862493588199, 0.342770201082665,
  0.326768218347074, 0.331446688250614, 0.271226240979971, 0.274928771278344,
  0.427097438109879, 0.227954602444087, 0.343976398134459, 0.248087260661523,
  0.333559794763154, 0.269119793639831, 0.285169037269755, 0.317639844332975,
  0.216504261100954, 0.213652609475002, 0.325084527268764, 0.229202638964418,
  0.417684846033223, 0.340283750637642, 0.271057288849122, 0.252930928770697,
  0.435396916627183, 0.461167542990859, 0.215931734912552, 0.349351899860469,
  0.312517924391466, 0.244659327655866, 0.303207632527713, 0.430208467665742,
  0.23259913373779, 0.274687706999462, 0.237736841712601, 0.284790134916951,
  0.251461534079972, 0.340438423343909, 0.30264227873013, 0.267256736373818,
  0.250884027776099, 0.360016257237221, 0.345655483071655, 0.248417921694399,
  0.193368514641029, 0.33281661018741, 0.309974419524456, 0.252039922476543,
  0.387202428328535, 0.241409643021456, 0.272753437714738, 0.253489747937355,
  0.261069660743027, 0.401132544134277, 0.403323927135992, 0.28824232504384,
  0.301376689010937, 0.351221504165762, 0.234085622888674, 0.210632570820526,
  0.435015253945255, 0.26379175901382, 0.346444338133825, 0.297733747421972,
  0.32248724368509, 0.222348686941321, 0.129135503773569, 0.205344717607118,
  0.241991429388265, 0.2734801648234, 0.223869476325476, 0.224944610325987,
  0.219442369820702, 0.245936533910029, 0.364874044988581, 0.371769970656037,
  0.265207029095921, 0.229527442948714, 0.3124499823212, 0.354874751704649,
  0.241409643021456, 0.274278721657908, 0.320722444212933, 0.209105111873967,
  0.335303439897311, 0.441911327651823, 0.290524625987779, 0.262747824634074,
  0.249731664234717, 0.413110248943755, 0.280433518967194, 0.25662857376008,
  0.384767047568092, 0.336550774647169, 0.306828341848628, 0.218881809977236,
  0.378858234779108, 0.272505012548096, 0.346233201706318, 0.21499718082412,
  0.316753415213728, 0.282775133054762, 0.313109972250615, 0.316197557948482,
  0.356200823525968, 0.228784739272493, 0.370392776235868, 0.353686263422402,
  0.308178644713754, 0.258269713388569, 0.260457529819865, 0.23840336458268,
  0.310593694918309, 0.264941262708354, 0.250550473514806, 0.389025366171,
  0.23259913373779, 0.214745709565214, 0.235696409825995, 0.365339030909007,
  0.346965633055199, 0.247437552351443, 0.372281099089784, 0.352271695449802,
  0.367834391696228, 0.198641365040246, 0.286691278409571, 0.27067050051468,
  0.287612804411272, 0.209627044691005, 0.248009751770778, 0.334961362605814,
  0.366298322670963, 0.244673114710386, 0.255236793801913, 0.27067050051468,
  0.247338948998465, 0.288718749155355, 0.206325972828026, 0.241427059741324,
  0.410758060636726, 0.157476177093047, 0.242818170764889, 0.2502321352329,
  0.362496027322634, 0.245726277221844, 0.182780503637141, 0.227433164684222,
  0.343175684603885, 0.239313596097979, 0.215927837408576, 0.235627099640301,
  0.246010934798416, 0.267306518884099, 0.194287900588817, 0.239840770923868,
  0.17553285817437, 0.244138729609023, 0.337329562871103, 0.410306783004745,
  0.292857836305853, 0.212549224706357, 0.311213649516187, 0.27757971144989,
  0.36032870909248, 0.358602583476195, 0.388102370766368, 0.285102940539784,
  0.224372664826014, 0.281362946311891, 0.338491873633952, 0.29953183555602,
  0.249081770371042, 0.263118107506395, 0.362742063281828, 0.24204597149078,
  0.328841874888658, 0.411501423916258, 0.318206009287404, 0.247304422478377,
  0.315075338654098, 0.277523203791762, 0.218130376179208, 0.406112539858874,
  0.255820898021464, 0.215959240236459, 0.247648792542508, 0.245157628610429,
  0.271616390324344, 0.377053537514284, 0.254868881125922, 0.419330525095722,
  0.23936490134804, 0.377845888604734, 0.231551695186328, 0.251172670622473,
  0.228427075122784, 0.308677771851371, 0.264432915485443, 0.39206070290678,
  0.227950105442148, 0.327696285340527, 0.227973117500364, 0.229448698131585,
  0.320532065167703, 0.162900772681632, 0.346687399256608, 0.132757627952109,
  0.26670558867496, 0.300767773423981, 0.345001284040143, 0.39206070290678,
  0.36676407551563, 0.24680064395488, 0.328833865819492, 0.267084463518589,
  0.281362946311891, 0.259561801021117, 0.24204597149078, 0.216563461964913,
  0.350251135448946, 0.309295617917496, 0.303759738139051, 0.408207990336502,
  0.229448698131585, 0.159914192450687, 0.237846318603771, 0.31798183469959,
  0.372377359315423, 0.385746346779522, 0.236180558748149, 0.272144810556835,
  0.353025065247434, 0.333327857795673, 0.323771623679159, 0.248417921694399,
  0.243665962667481, 0.3414901527449, 0.232801624905873, 0.27466851375609,
  0.354268669644066, 0.256698697560906, 0.31277988243698, 0.247878041755546,
  0.345655483071655, 0.23916760978384, 0.325117588578471, 0.209178688157539,
  0.178456417306029, 0.321162615778622, 0.357543936747908, 0.296525085703652,
  0.357896665159121, 0.365544230168428, 0.289870524276537, 0.36233205230183,
  0.24204597149078, 0.37033685096767, 0.331550165757199, 0.282245706670395,
  0.175506017906404, 0.19154079001114, 0.256036860227991, 0.345191418655272,
  0.259856964441913, 0.398317021809755, 0.339921830491766, 0.267823793731502,
  0.369153879006776, 0.281694462417708, 0.338491873633952, 0.222396805907914,
  0.214949622561849, 0.244022999627628, 0.208192352453665, 0.217345899157743,
  0.360192225827885, 0.276730181734053, 0.36032870909248, 0.252852969404964,
  0.304557157388712, 0.215715190370064, 0.339140120389054, 0.232873279352009,
  0.305544277697588, 0.256189758606541, 0.36434018964622, 0.328203536700415,
  0.245208290045875, 0.205322178187691, 0.270626968215912, 0.19248238625109,
  0.231020087688448, 0.187540266106836, 0.393413011641052, 0.263713861488989,
  0.236385207357083, 0.242540320503515, 0.224908987593979, 0.271537034417144,
  0.248221319332836, 0.442854072853565, 0.337844232520462, 0.25757846657266,
  0.365585889921455, 0.264907963740118, 0.262523219518815, 0.301002859987686,
  0.409606818483721, 0.306828341848628, 0.192932563493629, 0.233900221340907,
  0.314886757799924, 0.371769970656037, 0.228513973056878, 0.361786767813403,
  0.262302238110568, 0.404826081054428, 0.257127162409356, 0.345655483071655,
  0.308060609522499, 0.24064049950216, 0.355673210437743, 0.377053537514284,
  0.142720487254522, 0.199736387643765, 0.410386531525609, 0.295561936106165,
  0.189989908171182, 0.383929118826154, 0.329851149905408, 0.250042279161951,
  0.40445623454423, 0.388102370766368, 0.366051260163864, 0.214745709565214,
  0.296500123376571, 0.259379937055983, 0.375668418029709, 0.290135796326967,
  0.183213138318394, 0.347731299579313, 0.24311963579147, 0.282606290328329,
  0.222880051054137, 0.253824763435741, 0.326928765112932, 0.21058753462917,
  0.220867224559341, 0.281602846169177, 0.233972110803989, 0.472292166897414,
  0.347035202737531, 0.24639095185122, 0.372281099089784, 0.230523509844226,
  0.249369029951448, 0.197463147568147, 0.405414811324718, 0.278685095719482,
  0.280470947235912, 0.174280054713888, 0.348776665104074, 0.258788859272771,
  0.168500848857078, 0.337016416346922, 0.374892396773354, 0.249156808365248,
  0.240402607570962, 0.19620884649301, 0.343828239064444, 0.262523219518815,
  0.308506058543187, 0.256698697560906, 0.258754550824674, 0.211551247498772,
  0.257208344198502, 0.432844722205361, 0.353686263422402, 0.344257374514718,
  0.377885664632231, 0.367697579110893, 0.242009101092345, 0.222880051054137,
  0.375807321009996, 0.267201552918977, 0.249444125737912, 0.292317226349104,
  0.366407594742433, 0.270324039482483, 0.32951187756902, 0.271758720938618,
  0.273058070086472, 0.35288982224744, 0.329172782787065, 0.32747998126784,
  0.240360075062407, 0.320722444212933, 0.429334405721931, 0.378526376054899,
  0.229326948392686, 0.266183867351358, 0.332571689134127, 0.268904788894661,
  0.236662439146038, 0.266690442316752, 0.381501508889734, 0.26379175901382,
  0.276364300029359, 0.309295617917496, 0.261051076561394, 0.285776259364901,
  0.222348686941321, 0.202526070009307, 0.369978926519518, 0.290524625987779,
  0.271537034417144, 0.214461723440222, 0.316421253772939, 0.294116302166823,
  0.248221319332836, 0.338046264345585, 0.297129061791485, 0.282295142289261,
  0.293966237458242, 0.37033685096767, 0.308120683251702, 0.266671602417739,
  0.232873279352009, 0.095592335616053, 0.254975976486193, 0.23840336458268,
  0.270021324301967, 0.272449017826147, 0.189338757062818, 0.23256588571945,
  0.363000901621015, 0.298026990469107, 0.209657776206611, 0.252184096477778,
  0.24458986921705, 0.30199465245604, 0.300100364724901, 0.285776259364901,
  0.252039922476543, 0.243457020417874, 0.353686263422402, 0.363916341202638,
  0.330190599535586, 0.294116302166823, 0.382226270680055, 0.434730100897718,
  0.249444125737912, 0.216824047694186, 0.363000901621015, 0.207746257923578,
  0.300892329115018, 0.268391613555177, 0.250060344838161, 0.411707799714383,
  0.371053127107747, 0.400026648681132, 0.255452432175778, 0.317085763597813,
  0.331532763374983, 0.354025188069329, 0.225282386294455, 0.260821091564966,
  0.289333172527949, 0.271009354893809, 0.259343902052296, 0.253199342696694,
  0.21058753462917, 0.341729573948731, 0.248923910439661, 0.227973117500364,
  0.247723541254226, 0.336330708861335, 0.339140120389054, 0.266240584168283,
  0.209292608827687, 0.308120683251702, 0.276503252260941, 0.304242814976403,
  0.267256736373818, 0.369044156337918, 0.269474057060084, 0.363000901621015,
  0.347621580076735, 0.351114251230416, 0.263870450149262, 0.31277988243698,
  0.196693542493083, 0.437150062883487, 0.328495126925562, 0.26776853597736,
  0.3161366290201, 0.341835470379286, 0.425085868490181, 0.254975976486193,
  0.272144810556835, 0.270706156994613, 0.209105111873967, 0.279504185039984,
  0.249465312745838, 0.285306732668278, 0.226355968386112, 0.31344025153644,
  0.432467877921428, 0.235696409825995, 0.277037563683188, 0.319083766551276,
  0.303944611530043, 0.374892396773354, 0.231231781459212, 0.302596619914997,
  0.338491873633952, 0.242891932153314, 0.371067846570864, 0.187099754069165,
  0.27179542874003, 0.367025062085783, 0.211582185589034, 0.347731299579313,
  0.319902169140554, 0.475899573159165, 0.273667971731367, 0.282188620176678,
  0.360995953882906, 0.216824047694186), .Dim = c(500L, 2L), .Dimnames = list(
    c("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11",
      "12", "13", "14", "15", "16", "17", "18", "19", "20", "21",
      "22", "23", "24", "25", "26", "27", "28", "29", "30", "31",
      "32", "33", "34", "35", "36", "37", "38", "39", "40", "41",
      "42", "43", "44", "45", "46", "47", "48", "49", "50", "51",
      "52", "53", "54", "55", "56", "57", "58", "59", "60", "61",
      "62", "63", "64", "65", "66", "67", "68", "69", "70", "71",
      "72", "73", "74", "75", "76", "77", "78", "79", "80", "81",
      "82", "83", "84", "85", "86", "87", "88", "89", "90", "91",
      "92", "93", "94", "95", "96", "97", "98", "99", "100", "101",
      "102", "103", "104", "105", "106", "107", "108", "109", "110",
      "111", "112", "113", "114", "115", "116", "117", "118", "119",
      "120", "121", "122", "123", "124", "125", "126", "127", "128",
      "129", "130", "131", "132", "133", "134", "135", "136", "137",
      "138", "139", "140", "141", "142", "143", "144", "145", "146",
      "147", "148", "149", "150", "151", "152", "153", "154", "155",
      "156", "157", "158", "159", "160", "161", "162", "163", "164",
      "165", "166", "167", "168", "169", "170", "171", "172", "173",
      "174", "175", "176", "177", "178", "179", "180", "181", "182",
      "183", "184", "185", "186", "187", "188", "189", "190", "191",
      "192", "193", "194", "195", "196", "197", "198", "199", "200",
      "201", "202", "203", "204", "205", "206", "207", "208", "209",
      "210", "211", "212", "213", "214", "215", "216", "217", "218",
      "219", "220", "221", "222", "223", "224", "225", "226", "227",
      "228", "229", "230", "231", "232", "233", "234", "235", "236",
      "237", "238", "239", "240", "241", "242", "243", "244", "245",
      "246", "247", "248", "249", "250", "251", "252", "253", "254",
      "255", "256", "257", "258", "259", "260", "261", "262", "263",
      "264", "265", "266", "267", "268", "269", "270", "271", "272",
      "273", "274", "275", "276", "277", "278", "279", "280", "281",
      "282", "283", "284", "285", "286", "287", "288", "289", "290",
      "291", "292", "293", "294", "295", "296", "297", "298", "299",
      "300", "301", "302", "303", "304", "305", "306", "307", "308",
      "309", "310", "311", "312", "313", "314", "315", "316", "317",
      "318", "319", "320", "321", "322", "323", "324", "325", "326",
      "327", "328", "329", "330", "331", "332", "333", "334", "335",
      "336", "337", "338", "339", "340", "341", "342", "343", "344",
      "345", "346", "347", "348", "349", "350", "351", "352", "353",
      "354", "355", "356", "357", "358", "359", "360", "361", "362",
      "363", "364", "365", "366", "367", "368", "369", "370", "371",
      "372", "373", "374", "375", "376", "377", "378", "379", "380",
      "381", "382", "383", "384", "385", "386", "387", "388", "389",
      "390", "391", "392", "393", "394", "395", "396", "397", "398",
      "399", "400", "401", "402", "403", "404", "405", "406", "407",
      "408", "409", "410", "411", "412", "413", "414", "415", "416",
      "417", "418", "419", "420", "421", "422", "423", "424", "425",
      "426", "427", "428", "429", "430", "431", "432", "433", "434",
      "435", "436", "437", "438", "439", "440", "441", "442", "443",
      "444", "445", "446", "447", "448", "449", "450", "451", "452",
      "453", "454", "455", "456", "457", "458", "459", "460", "461",
      "462", "463", "464", "465", "466", "467", "468", "469", "470",
      "471", "472", "473", "474", "475", "476", "477", "478", "479",
      "480", "481", "482", "483", "484", "485", "486", "487", "488",
      "489", "490", "491", "492", "493", "494", "495", "496", "497",
      "498", "499", "500"), NULL)), linpred = structure(c(-0.760781316206543,
        -0.953024148744482, -0.899673412392988, -1.31809643665836, -1.10116160211944,
        -0.448274099787041, -0.641179788934882, -1.28523401800262, -1.09707560079553,
        -0.996126256966908, -0.661722861702578, -0.668772404502818, -1.28277701473864,
        -0.652754130283752, -1.0012428378001, -0.954272824441622, -1.2999760375865,
        -1.29321927861056, -0.988650696072203, -1.01155871209874, -0.65773023139861,
        -1.29168365157057, -1.03856550857943, -0.617785031474231, -1.06277092611974,
        -0.64237396099873, -1.30427579329847, -1.07996994896761, -1.10331147997543,
        -1.2198968563784, -0.631931697126812, -0.479139010050696, -0.671550874758501,
        -1.30611854574646, -1.29383352942655, -1.04628173614535, -1.16412231075895,
        -0.704106168006246, -0.970837422408342, -0.556939671181574, -1.32516032104231,
        -1.34394231652026, -1.08872098775787, -1.05072566901554, -1.00359640976991,
        -0.541454649665243, -0.665408366598549, -1.054636349183, -0.981332187306823,
        -0.448274099787041, -0.690592650054352, -0.656194604358622, -0.683835891078405,
        -1.34174509307418, -1.0940977177355, -0.197250629131939, -1.30980405064243,
        -1.02699116723056, -0.664328471632623, -1.27417750331471, -1.07751294570363,
        -1.06943041884309, -1.05110016061584, -0.556301285709832, -0.340885299335993,
        -0.950467277043168, -0.995714580456147, -1.33622608895435, -1.02397011799193,
        -1.37807952147963, -1.11098961517537, -0.495209850654265, -1.00247133943209,
        -1.0811984505996, -0.440557872221128, -0.953687005354383, -0.660494360070588,
        -0.668172495270528, -1.03148766648526, -0.961623660168414, -1.08826233498354,
        -0.695831767368019, -0.815380728255177, -1.08580533171956, -0.715122336282803,
        -1.31471805717039, -1.31441093176239, -1.00738534596006, -1.2198968563784,
        -1.06768493264771, -1.28216276392264, -0.970530297000345, -0.637767079878766,
        -0.529932874700876, -1.28124138769865, -1.40508631796033, -1.13955227811914,
        -0.972977574269167, -0.642988211814725, -1.02377143891935, -0.687477154330363,
        -0.946556596875708, -1.00646396973606, -1.33468120869023, -0.591024309756443,
        -0.972977574269167, -0.967766168328366, -0.945346013544542, -1.34512347256215,
        -0.68199313863042, -0.663872739558561, -1.0276556228879, -0.689057023014364,
        -0.99285396227119, -1.07014193591169, -0.718342064594018, -0.741268342373955,
        -0.992643326376171, -0.673086501798489, -0.796142725724896, -0.973615959740909,
        -1.31103255227442, -0.714483950811061, -0.663258488742566, -1.54783652792973,
        -0.915105867524815, -1.08075868542905, -0.702263415558261, -0.675850630470468,
        -0.510589739401589, -0.429621916343999, -0.764393355226589, -0.587804581445228,
        -1.31656080961837, -0.792232045557436, -0.460486826607654, -0.634049380456207,
        -0.5453127634482, -0.997250207496135, -0.649130719974677, -1.28615539422661,
        -1.26742074433876, -0.682300264038417, -0.82309695582109, -1.02674509246765,
        -0.768497543772456, -0.602598651105314, -0.663258488742566, -0.942112664005513,
        -0.86109227456342, -0.838581977337421, -0.529932874700876, -1.10801155667266,
        -0.53373842209933, -1.28922664830659, -0.986500818216219, -1.0275769863178,
        -0.726058292159931, -0.378828051693819, -0.997250207496135, -0.676157755878465,
        -0.428737456109347, -1.33775246277021, -0.468203054173567, -1.09233302677792,
        -1.29414065483455, -1.32239619237033, -1.06307805152774, -1.01541682588169,
        -0.627939066822843, -0.644791827954928, -0.680457511590432, -1.31963206369835,
        -0.869446887601075, -1.05724266877579, -1.43658961369573, -1.08396257927158,
        -1.67901239655026, -0.776799590425609, -1.30458291870647, -1.28308414014664,
        -1.04495765245588, -1.06645643101571, -0.765225249076738, -0.792284611941939,
        -0.436699758438171, -0.649130719974677, -0.671243749350504, -1.30396866789047,
        -1.1311602393704, -1.28062713688266, -0.325452844204165, -1.06553505479172,
        -0.64360246263072, -0.869446887601075, -2.0686818886289, -1.30857554901044,
        -1.52829988425204, -0.922576020327818, -1.03915132766667, -0.950414710658665,
        -0.707353542332386, -0.668479620678525, -0.575591854624616, -1.10453998160742,
        -0.652754130283752, -0.688135646790371, -0.649534401972537, -1.23205701681451,
        -0.348601526901906, -1.01690623360798, -0.571733740841659, -1.11467512007134,
        -0.757509021510825, -1.28277701473864, -0.693049653318333, -0.834723863554464,
        -0.990800573928186, -1.28998128994337, -1.05693554336779, -1.07444169162365,
        -0.803220567819068, -0.691921087200559, -1.27356325249871, -0.571733740841659,
        -0.780657704208566, -1.30396866789047, -1.06338517693574, -0.761419701678285,
        -0.895815298610031, -1.2813806021428, -1.13033851587921, -1.09194783987952,
        -1.02489149421592, -0.670936623942506, -1.25882123291483, -0.911833572829097,
        -1.1060756086474, -1.00400696647208, -1.1444662846471, -0.544726944360962,
        -0.687231079567453, -0.981332187306823, -0.741490747291759, -1.03534578026822,
        -1.11958589802153, -0.417409189523387, -0.649481835588034, -0.792232045557436,
        -1.17395032381487, -0.904169911647686, -1.37807952147963, -0.382440090713865,
        -1.31410380635439, -0.298393481338965, -1.44811138866009, -1.29598340728254,
        -0.606456764888271, -1.15045080828518, -0.713627055654172, -0.659880109254593,
        -1.36723650193798, -1.08918371120754, -1.20896090050127, -0.734412905197587,
        -0.815380728255177, -0.696120907398309, -1.16974137719996, -0.980972560872263,
        -0.7150697698983, -1.01986075875189, -0.333116505385576, -0.548585058143918,
        -0.437338143909913, -1.15430892206814, -0.665715492006547, -1.3008974138105,
        -0.35240707430036, -1.27571313035469, -1.06399942775173, -1.43658961369573,
        -0.698885036070287, -0.290729820157554, -1.06215667530375, -1.31901781288236,
        -1.07075618672768, -0.713934181062169, -0.579203893644663, -0.791646226470197,
        -1.28277701473864, -0.646366591302699, -0.78778811268724, -0.718342064594018,
        -1.10914686272738, -1.40869835698038, -1.12481025853526, -0.969301795368354,
        -1.18195410402058, -1.36570087489799, -0.991414824744181, -1.00442830362006,
        -1.29383352942655, -0.583062007427619, -0.634049380456207, -0.379466437165561,
        -1.33498833409823, -0.634388700390792, -0.961009409352419, -1.26895637137875,
        -0.640531208550744, -1.37368613550593, -1.08304120304758, -1.18439258768679,
        -0.576177673711855, -1.3254674464503, -1.09194783987952, -1.29168365157057,
        -1.11774637415131, -0.935034821911341, -0.502926078220179, -0.880382843478204,
        -0.174933840284347, -0.66663686823054, -0.7228408178941, -1.27049199841874,
        -1.34297359470617, -0.68199313863042, -0.887852996281207, -0.537596535882287,
        -1.07843432192762, -0.274412904791075, -1.34235934389017, -1.08211982682359,
        -1.08918371120754, -1.38257602073433, -0.67554350506247, -1.11098961517537,
        -0.672044699198536, -0.710625837028104, -1.4436674557899, -0.888684890131356,
        -0.973294425672323, -1.0276295527023, -0.571733740841659, -1.28615539422661,
        -1.11713212333532, -0.900259231480226, -0.950874270888499, -0.668172495270528,
        -1.08611245712756, -1.05693554336779, -0.661722861702578, -1.17359949098292,
        -1.03856550857943, -0.703495428549429, -0.722200178376975, -0.66818658541558,
        -1.30888267441843, -1.06676355642371, -0.66018723466259, -0.682300264038417,
        -1.29782615973052, -0.657423105990612, -0.459848441135912, -1.09962597507946,
        -1.10116160211944, -0.791646226470197, -0.683835891078405, -0.634388700390792,
        -0.656808855174617, -1.31809643665836, -0.448274099787041, -1.09655472099948,
        -0.587804581445228, -0.695813781990311, -0.841555630885725, -1.05386428928781,
        -1.28093426229065, -0.662644237926571, -1.06277092611974, -0.960088033128426,
        -0.87266661591229, -1.04628173614535, -1.12296750608727, -0.337027185553036,
        -1.30980405064243, -0.7150697698983, -1.11528937088733, -1.11129674058336,
        -0.818653022950895, -0.68322164026241, -0.688115539802105, -1.30642567115445,
        -0.648209343750684, -1.20124467293536, -1.06338517693574, -1.3008974138105,
        -0.367007635582038, -0.895815298610031, -2.01442222090459, -1.08100476019196,
        -1.30796129819444, -0.734360338813084, -0.658037356806607, -0.95729904437443,
        -0.976365679752299, -0.663872739558561, -1.7636448250124, -0.78754203792433,
        -0.703547994933932, -1.30120453921849, -1.34051659144219, -0.506145806531394,
        -0.87266661591229, -1.29321927861056, -1.30243304085049, -0.668172495270528,
        -1.0689134342797, -0.776852156810112, -0.818653022950895, -0.205851316932504,
        -0.270554791008118, -1.29598340728254, -1.12730212558744, -1.29659765809853,
        -0.802974493056158, -1.15103662737242, -1.32147481614634, -1.11590362170333,
        -0.642066835590732, -1.06277092611974, -0.977901306792287, -0.923407914177967,
        -1.11068248976737, -0.678614759142446, -0.510642305786092, -1.00384248453282,
        -0.517720147880264, -1.31041830145842, -0.386544279259733, -0.537010716795048,
        -1.29199077697857, -1.33345270705824, -1.29383940372632, -1.09471196855149,
        -0.965261346703254, -0.69133526811332, -0.671798624435626, -1.28584826881862,
        -1.37866534056687, -1.79919974290916, -0.729916405942888, -0.31709823116651,
        -0.62701769059885, -0.996126256966908, -0.742076566378997, -1.08334832845558,
        -0.776799590425609, -0.490713351399566, -1.15406284730523, -1.01927493966465,
        -1.33038145297827, -1.35710136347406, -0.36398141564923, -0.796142725724896,
        -0.595520809011142, -0.283013592591641, -1.08826233498354, -0.429569349959496,
        -1.08100476019196, -0.658344482214605, -0.390402393042689, -1.34394231652026,
        -0.650973472422662, -0.722838563848716, -0.701649164742266, -0.988410029400994,
        -0.969757845957952, -0.293703473705859, -1.2198968563784, -0.645623721805077,
        -1.10883973731938, -0.69212827709434, -0.999092959944121, -0.918963981307772,
        -0.7646394299895, -1.28615539422661, -1.30304729166648, -0.730502225030127,
        -1.21281901428423, -0.332284611535427, -0.662029987110576, -0.989264946888198,
        -1.08304120304758, -0.2598649098939, -0.155643271369563, -1.28953377371459,
        -0.621889220020098, -0.788373931774479, -1.12730212558744, -0.832069645097484,
        -0.281000661454242, -1.1936927908192, -0.97096746961436, -1.16512749331305,
        -0.920823476921225, -1.09083256137567, -0.661341069128823, -0.834746999241645,
        -1.00858563042101, -1.09390301598593, -0.575293584675125, -0.638191431709344,
        -1.10706792654631, -1.42826914574159, -0.695473337249347, -0.800238893645699,
        -1.08776210676542, -0.459087028849013, -1.14496666346982, -0.980697341821191,
        -1.08008597023978, -1.0404163818728, -0.400748391254174, -0.39163434611868,
        -0.903935976564824, -0.840750759129788, -0.613674267303309, -1.18538342605509,
        -1.32111665714477, -0.261417635634108, -1.02635301456032, -0.634705539023214,
        -0.858112987194398, -0.742364800097001, -1.25203142841404, -1.90862412219578,
        -1.35321829734632, -1.14179238267553, -0.977036689279775, -1.24325751960379,
        -1.23708030177746, -1.26891892877044, -1.12040302658778, -0.554271121766907,
        -0.524631083605923, -1.01907802444937, -1.21098143759029, -0.788690180087825,
        -0.597679566225255, -1.14496666346982, -0.973021205295554, -0.750453726120611,
        -1.33032802097554, -0.684294723339166, -0.233408614995295, -0.892837443323617,
        -1.03173526784049, -1.10004392520644, -0.351122480634591, -0.942312233150556,
        -1.06356601929228, -0.469362900621339, -0.678703297193433, -0.81498922734342,
        -1.27219456637814, -0.494397256866941, -0.981950100315405, -0.635638168938656,
        -1.29506239348707, -0.768732225121169, -0.930737414440817, -0.78561972547757,
        -0.77130184687135, -0.591892156870385, -1.21518597309099, -0.530532170635556,
        -0.60287478757143, -0.80864813505448, -1.05498124235248, -1.04359189686078,
        -1.16145301741153, -0.797345188968265, -1.0204422594413, -1.09567858105461,
        -0.451410892323376, -1.1936927908192, -1.29655302026273, -1.17642050171224,
        -0.552265175098215, -0.632404022354474, -1.11232574364745, -0.522443244611947,
        -0.609068585387927, -0.541518583962324, -1.39480756779088, -0.911508364498011,
        -0.991223402356405, -0.907006431175079, -1.3271749552494, -1.1092552890372,
        -0.685829950644293, -0.548130212546398, -1.12722752219585, -1.07087460640902,
        -0.991223402356405, -1.11285533590118, -0.90161489444843, -1.34721552133194,
        -1.144871560571, -0.360832481320863, -1.67712774800099, -1.13729052694418,
        -1.09737461701087, -0.564546993539234, -1.12153710747822, -1.49762172090752,
        -1.22286210961662, -0.649174062410388, -1.15644637928074, -1.28955679444275,
        -1.1768052904628, -1.12000188017309, -1.00833143331348, -1.42238539929421,
        -1.15355267460331, -1.54691103751642, -1.13012122687328, -0.675217404507303,
        -0.362697299344331, -0.881544434924423, -1.30962725396675, -0.79445148429083,
        -0.956498946227186, -0.57393774079708, -0.581434493895635, -0.455295849022248,
        -0.919288249616097, -1.24036381492635, -0.937710977277625, -0.670022183161128,
        -0.849528210254601, -1.10351552623138, -1.02982461558527, -0.563482485597671,
        -1.14149506244487, -0.713427753322652, -0.357762026710609, -0.762028544830351,
        -1.11304080911922, -0.776497068217525, -0.956780756537731, -1.27659506529608,
        -0.38005952740894, -1.06780415179876, -1.28937132122471, -1.11119166275701,
        -1.12460756208847, -0.986437104627014, -0.502073393392578, -1.07281098012883,
        -0.325522253302935, -1.1561645689702, -0.498701419183772, -1.19957013913172,
        -1.0923677886808, -1.21721417750687, -0.806308113311115, -1.02305415380819,
        -0.438658354518793, -1.21992240896627, -0.718622974668827, -1.21979165500637,
        -1.211426768152, -0.751327724439851, -1.63680135573494, -0.633632222269964,
        -1.876793370744, -1.01140188792374, -0.843644463807223, -0.641085136386779,
        -0.438658354518793, -0.546124265877706, -1.11574904057861, -0.713464042136585,
        -1.00946551420392, -0.937710977277625, -1.04824734324679, -1.14149506244487,
        -1.28580642912684, -0.617935498967299, -0.80341440863368, -0.829457750730594,
        -0.371378413376635, -1.211426768152, -1.65886666427279, -1.16452347202178,
        -0.763062035264225, -0.522031348359233, -0.465227938069522, -1.17373483585255,
        -0.983767796431445, -0.605768492248864, -0.693171820580607, -0.736492451713495,
        -1.10706792654631, -1.1326848450288, -0.656660631846874, -1.19255870992876,
        -0.971063806706868, -0.600327940920727, -1.06319846988338, -0.787154952782697,
        -1.10996163122374, -0.638191431709344, -1.15724848191083, -0.730351542492986,
        -1.3298831867088, -1.52684057799241, -0.748434019762416, -0.586040175811017,
        -0.863900396549268, -0.584504948505889, -0.551380291386296, -0.896012958311598,
        -0.565256626764776, -1.14149506244487, -0.530771992826433, -0.701182223695566,
        -0.933349308807706, -1.54709651073446, -1.44002943766936, -1.06667007090832,
        -0.640243850854038, -1.04671211594167, -0.412482466869419, -0.663642585797563,
        -1.00569192574358, -0.535848394105379, -0.936072001380048, -0.670022183161128,
        -1.25175316041806, -1.29534420379762, -1.13074847130898, -1.33585606928171,
        -1.28120074721146, -0.574529928805775, -0.960739386854535, -0.57393774079708,
        -1.08345382267227, -0.825690047733919, -1.29081325745691, -0.667128478483693,
        -1.19215756351408, -0.821033702087948, -1.06586753596102, -0.556575512732471,
        -0.716321458000087, -1.12433381751841, -1.35335643055245, -0.991443932957082,
        -1.43396021800395, -1.20256018090166, -1.46607277976628, -0.432988164661848,
        -1.02675416097501, -1.17260075496211, -1.13880234090559, -1.23728463703088,
        -0.9868382510417, -1.10812120814676, -0.229586884182324, -0.672915887838563,
        -1.058592787968, -0.551200667156653, -1.0206132517545, -1.03289507019552,
        -0.842526884359731, -0.365591004021766, -0.81498922734342, -1.43106651332651,
        -1.18641780070825, -0.777371066536766, -0.524631083605923, -1.21672120039611,
        -0.567617448149489, -1.03403678450923, -0.385396118202901, -1.06095412492539,
        -0.638191431709344, -0.80920181798855, -1.14917119897051, -0.594193673539125,
        -0.502073393392578, -1.79287593509839, -1.38794275347554, -0.362367708625991,
        -0.868521999954446, -1.45007575077547, -0.472904074595159, -0.708858360221203,
        -1.09838681251401, -0.386931345508028, -0.455295849022248, -0.549194720487961,
        -1.29655302026273, -0.864020066631514, -1.04919383299761, -0.507974721224772,
        -0.89472461273406, -1.49472801623008, -0.629026540354582, -1.1356515510466,
        -0.931570068057116, -1.24896097380379, -1.07831635299, -0.722108867354956,
        -1.32138754589453, -1.2606197476684, -0.936524823795686, -1.18601665429357,
        -0.110944992407492, -0.632096994964837, -1.11795422015485, -0.522443244611947,
        -1.20535754848659, -1.10198029892625, -1.40222580364467, -0.382953232086375,
        -0.950993347182861, -0.942126759932519, -1.55559215154872, -0.6244208584392,
        -1.05227301089308, -1.59628949025085, -0.676618586813529, -0.511284757223342,
        -1.10311437981669, -1.15047349670783, -1.41015984084216, -0.646280357732953,
        -1.03289507019552, -0.807112907749352, -1.06319846988338, -1.05245187874749,
        -1.31560013653966, -1.06052916168781, -0.270254070318351, -0.60287478757143,
        -0.644378813405855, -0.498532219418759, -0.542106989345296, -1.14169604558302,
        -1.24896097380379, -0.507382533216077, -1.00886744073156, -1.10157915251156,
        -0.884156329291312, -0.547659493182833, -0.992979160262209, -0.710393587526331,
        -0.98571780331208, -0.979162114516063, -0.606360680257559, -0.711928814831458,
        -0.719604951357095, -1.15070642627564, -0.750453726120611, -0.284567273053588,
        -0.495807714506337, -1.21211551848073, -1.01407119611931, -0.696576541780185,
        -1.00018632669926, -1.17106552765698, -1.01147933509845, -0.483179946367485,
        -1.02635301456032, -0.962568165892601, -0.80341440863368, -1.04051271896531,
        -0.915987080743097, -1.25203142841404, -1.37058052541093, -0.53230722013156,
        -0.892837443323617, -0.9868382510417, -1.29823790847505, -0.770267452426296,
        -0.875475215259008, -1.10812120814676, -0.672012904898147, -0.861006691871833,
        -0.933105295362244, -0.876198136480082, -0.530771992826433, -0.808920007678004,
        -1.01157567219096, -1.19215756351408, -2.24718756945567, -1.07224713332458,
        -1.16145301741153, -0.994514387567337, -0.982232569126318, -1.4543124878385,
        -1.19387906686936, -0.562362922087341, -0.856710900876992, -1.32698948203136,
        -1.0869974670223, -1.12767801669873, -0.837817453851899, -0.846819978795204,
        -0.915987080743097, -1.08776210676542, -1.13381892591924, -0.60287478757143,
        -0.558406084318725, -0.707323132916076, -0.875475215259008, -0.480109491757231,
        -0.262577933792714, -1.10157915251156, -1.28427120182172, -0.562362922087341,
        -1.3385643007411, -0.843052275798528, -1.00279822106614, -1.0982904754215,
        -0.356909889989461, -0.527701538216178, -0.405354073169556, -1.06974052551858,
        -0.767196997816042, -0.701260746604217, -0.60139244886229, -1.23514392805764,
        -1.0417052876116, -0.898624852678487, -0.989507559237268, -1.04938142413723,
        -1.08162119754491, -1.32138754589453, -0.655596123905311, -1.10435969508691,
        -1.21979165500637, -1.11079051634233, -0.679689041423784, -0.667128478483693,
        -1.01378085176719, -1.3291946616076, -0.808920007678004, -0.961873467744976,
        -0.827174611308457, -1.00858563042101, -0.536319579990426, -0.99729262202182,
        -0.562362922087341, -0.629510317677039, -0.614144986666873, -1.02594785848562,
        -0.787154952782697, -1.4070893862319, -0.252736521601803, -0.714999269441712,
        -1.00597373605412, -0.771583657181896, -0.655125404541747, -0.301929501118197,
        -1.07224713332458, -0.983767796431445, -0.991042786542396, -1.33032802097554,
        -0.946922341108389, -1.10146599040948, -0.918288597411837, -1.22900301883713,
        -0.784084498172442, -0.271789297623478, -1.17642050171224, -0.959204159549408,
        -0.757985633985278, -0.828583752411354, -0.511284757223342, -1.20136892734484,
        -0.834963349774919, -0.670022183161128, -1.13688938052949, -0.527638465958121,
        -1.46896648444371, -0.985532330094043, -0.545000694022731, -1.31541466332162,
        -0.629026540354582, -0.754221429117286, -0.0964764690203174,
        -0.976091659905809, -0.933631119118252, -0.571044036119645, -1.28427120182172
      ), .Dim = c(500L, 2L), .Dimnames = list(c("1", "2", "3", "4",
        "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15",
        "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26",
        "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37",
        "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48",
        "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59",
        "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "70",
        "71", "72", "73", "74", "75", "76", "77", "78", "79", "80", "81",
        "82", "83", "84", "85", "86", "87", "88", "89", "90", "91", "92",
        "93", "94", "95", "96", "97", "98", "99", "100", "101", "102",
        "103", "104", "105", "106", "107", "108", "109", "110", "111",
        "112", "113", "114", "115", "116", "117", "118", "119", "120",
        "121", "122", "123", "124", "125", "126", "127", "128", "129",
        "130", "131", "132", "133", "134", "135", "136", "137", "138",
        "139", "140", "141", "142", "143", "144", "145", "146", "147",
        "148", "149", "150", "151", "152", "153", "154", "155", "156",
        "157", "158", "159", "160", "161", "162", "163", "164", "165",
        "166", "167", "168", "169", "170", "171", "172", "173", "174",
        "175", "176", "177", "178", "179", "180", "181", "182", "183",
        "184", "185", "186", "187", "188", "189", "190", "191", "192",
        "193", "194", "195", "196", "197", "198", "199", "200", "201",
        "202", "203", "204", "205", "206", "207", "208", "209", "210",
        "211", "212", "213", "214", "215", "216", "217", "218", "219",
        "220", "221", "222", "223", "224", "225", "226", "227", "228",
        "229", "230", "231", "232", "233", "234", "235", "236", "237",
        "238", "239", "240", "241", "242", "243", "244", "245", "246",
        "247", "248", "249", "250", "251", "252", "253", "254", "255",
        "256", "257", "258", "259", "260", "261", "262", "263", "264",
        "265", "266", "267", "268", "269", "270", "271", "272", "273",
        "274", "275", "276", "277", "278", "279", "280", "281", "282",
        "283", "284", "285", "286", "287", "288", "289", "290", "291",
        "292", "293", "294", "295", "296", "297", "298", "299", "300",
        "301", "302", "303", "304", "305", "306", "307", "308", "309",
        "310", "311", "312", "313", "314", "315", "316", "317", "318",
        "319", "320", "321", "322", "323", "324", "325", "326", "327",
        "328", "329", "330", "331", "332", "333", "334", "335", "336",
        "337", "338", "339", "340", "341", "342", "343", "344", "345",
        "346", "347", "348", "349", "350", "351", "352", "353", "354",
        "355", "356", "357", "358", "359", "360", "361", "362", "363",
        "364", "365", "366", "367", "368", "369", "370", "371", "372",
        "373", "374", "375", "376", "377", "378", "379", "380", "381",
        "382", "383", "384", "385", "386", "387", "388", "389", "390",
        "391", "392", "393", "394", "395", "396", "397", "398", "399",
        "400", "401", "402", "403", "404", "405", "406", "407", "408",
        "409", "410", "411", "412", "413", "414", "415", "416", "417",
        "418", "419", "420", "421", "422", "423", "424", "425", "426",
        "427", "428", "429", "430", "431", "432", "433", "434", "435",
        "436", "437", "438", "439", "440", "441", "442", "443", "444",
        "445", "446", "447", "448", "449", "450", "451", "452", "453",
        "454", "455", "456", "457", "458", "459", "460", "461", "462",
        "463", "464", "465", "466", "467", "468", "469", "470", "471",
        "472", "473", "474", "475", "476", "477", "478", "479", "480",
        "481", "482", "483", "484", "485", "486", "487", "488", "489",
        "490", "491", "492", "493", "494", "495", "496", "497", "498",
        "499", "500"), NULL)))

mice.options <- NULL
mice.options$seed <- as.vector(matrix(seeds,ncol=1,nrow=5*5))[1:4]
mice.options$maxit <- 2

set.seed(12345)
test_that("output replicates from specified seed for mipred and averaging method",{
  expect_equal(mipred.cv(Status~age10+cyto,family=binomial,data=cll_bin[1:500,-1], nimp=2, folds=2, mice.options=mice.options)[2:3],output)
    })

output <- list(pred = structure(c(0.324626090711691, 0.238581567478475,
  0.293592625651323, 0.215010760130649, 0.232880215770661, 0.47232338268786,
  0.352656783713505, 0.214139162183645, 0.249097262126295, 0.273095090570347,
  0.214383275849187, 0.39631812077668, 0.214074099369918, 0.349895510961235,
  0.239962808080433, 0.250188503953077, 0.214529841143926, 0.369655343433018,
  0.239601574703534, 0.331696120559728, 0.369553989161271, 0.214310020509734,
  0.264364606535924, 0.388376763536027, 0.231802626489789, 0.368991119532943,
  0.214643886717997, 0.232284955547446, 0.232940663804656, 0.229127992442298,
  0.368608571626731, 0.392279505044733, 0.370060875386354, 0.214692776877661,
  0.214366995311559, 0.26279659634823, 0.372836893841835, 0.215508804003521,
  0.239091198065259, 0.368661537630019, 0.233113432668393, 0.181598759735883,
  0.254280173045383, 0.231727229247033, 0.297747461922618, 0.339521596260721,
  0.369835557181046, 0.294380359249285, 0.272443451547587, 0.400008928020172,
  0.370759721211097, 0.369497686201993, 0.370511681545583, 0.215639576894638,
  0.232681677726231, 0.496529529775724, 0.214790581469845, 0.266727830318417,
  0.347144264514679, 0.238397230092369, 0.232216008563053, 0.258128616158334,
  0.231475730281952, 0.373197945837601, 0.422681467838723, 0.278895258908529,
  0.23980417194121, 0.22628683193719, 0.240615733029875, 0.201194820815077,
  0.233156638817423, 0.383826480617341, 0.215329085213238, 0.232319434393133,
  0.401949251997194, 0.282003367509617, 0.369655343433018, 0.369936943362472,
  0.262160668307625, 0.238827502868948, 0.2325177570115, 0.311486597397749,
  0.33534157414535, 0.232448761848999, 0.331022310964137, 0.370444046212349,
  0.214912882721181, 0.37118831389449, 0.229127992442298, 0.231940363398388,
  0.214057835914126, 0.369835557181046, 0.231578925849262, 0.375266281735496,
  0.369216224700951, 0.15773291632776, 0.233961288814303, 0.277932326994668,
  0.369013627485735, 0.263726241532948, 0.341672433407, 0.305455537785086,
  0.240112697022856, 0.215451608953901, 0.364734474910827, 0.277932326994668,
  0.239003277486459, 0.238362129304879, 0.215729516628254, 0.370444046212349,
  0.239038443056555, 0.371933193483878, 0.370703342568612, 0.242688143977387,
  0.232009253272187, 0.277631682171715, 0.372622184295006, 0.23297521044333,
  0.239302297935107, 0.312515467298546, 0.274047623919981, 0.214823190192478,
  0.360241817538008, 0.369756709199038, 0.174140474088412, 0.290253088455758,
  0.281136987525367, 0.240139154659558, 0.370218631818535, 0.34680471038667,
  0.400189911785393, 0.352601122006445, 0.361173216640409, 0.214969973943728,
  0.283337487258274, 0.392459279167953, 0.318133125587485, 0.338616436517364,
  0.215190286100499, 0.369238738350008, 0.214163564447386, 0.368709818251041,
  0.370455318415024, 0.276822365587971, 0.292705155791175, 0.322857522896712,
  0.361931507716123, 0.369756709199038, 0.233168493267176, 0.302038758382724,
  0.280370611002668, 0.375266281735496, 0.250469735041162, 0.341335433161044,
  0.214244919936045, 0.239539937948443, 0.236069694254624, 0.332646210105489,
  0.417577815275616, 0.23984823033324, 0.370229901195812, 0.43629161536808,
  0.215533319538515, 0.390534850952092, 0.243102394585783, 0.214375135467994,
  0.233035675644361, 0.213968402977988, 0.269104451615014, 0.368462346935985,
  0.381682247945406, 0.370387687316734, 0.215051551936072, 0.296269143455305,
  0.23164774074818, 0.188640106426973, 0.232397024844485, 0.197929983066027,
  0.286629589697947, 0.214652034516066, 0.214082231434961, 0.231303809091734,
  0.23190592381623, 0.372429827779515, 0.313383915786465, 0.402920571049644,
  0.369238738350008, 0.370049608130883, 0.214635739144679, 0.245947663852229,
  0.214017181208033, 0.426628796568253, 0.231880096472385, 0.36903613600853,
  0.296269143455305, 0.108918438640676, 0.214757976343154, 0.196650677596175,
  0.315781463750501, 0.285286139430701, 0.250946974091373, 0.301722933436266,
  0.369948209202095, 0.368486052843686, 0.23297521044333, 0.291610385382508,
  0.370669517074174, 0.346400135249635, 0.199660096997108, 0.394206969681967,
  0.240412666984509, 0.369426458802373, 0.233260356312065, 0.374319834601111,
  0.214074099369918, 0.370849934364046, 0.303903929737124, 0.239663222320218,
  0.213259937159199, 0.231639138104731, 0.232129844909078, 0.314962024816509,
  0.364734474910827, 0.213830241934863, 0.369426458802373, 0.28580442126006,
  0.214635739144679, 0.231819840479545, 0.320378317885479, 0.294431010076932,
  0.208554668755289, 0.233701513717669, 0.370184824535026, 0.24064222854206,
  0.370038341016949, 0.213440490809015, 0.258615413120865, 0.239760119089703,
  0.240042153073459, 0.234099917516564, 0.376036744522677, 0.371253324573025,
  0.272443451547587, 0.329069384049474, 0.261380132287562, 0.248201800907025,
  0.407788455531309, 0.314638778415765, 0.283337487258274, 0.234932887018564,
  0.266727830318417, 0.201194820815077, 0.44824667262402, 0.214904727731216,
  0.398680620246535, 0.165949844210592, 0.214423981126502, 0.360999258164521,
  0.242221532242644, 0.371605822736612, 0.369632819267917, 0.216318884501916,
  0.214660182538886, 0.209097413991284, 0.326565483037722, 0.278442453853321,
  0.370962713475802, 0.238533994323685, 0.239381493314604, 0.300023712356514,
  0.237529616561535, 0.389998820289772, 0.375089520899818, 0.312031697103348,
  0.241480932292527, 0.369846821745508, 0.232431515288679, 0.385205165770244,
  0.213887123909263, 0.231837055361843, 0.172404706259069, 0.371064226705313,
  0.435543803631305, 0.231785413392586, 0.215035234539684, 0.214171698984824,
  0.371617109423376, 0.398013313499199, 0.317582287427801, 0.214074099369918,
  0.213976532121079, 0.318458293836737, 0.277631682171715, 0.23984823033324,
  0.217184540257398, 0.233545744915809, 0.23904723500355, 0.232849227141622,
  0.216277918539656, 0.239680837919879, 0.315997105726887, 0.214366995311559,
  0.397045957700519, 0.318133125587485, 0.412857274679967, 0.37118831389449,
  0.368698568054849, 0.238809930287242, 0.213708389076762, 0.368923599095416,
  0.216491002884528, 0.232371159353273, 0.235228389071004, 0.331418032802328,
  0.23312207345236, 0.232621276517659, 0.214310020509734, 0.233346812076401,
  0.282156068022782, 0.381917772910272, 0.297798447587083, 0.430033279750828,
  0.369880616289209, 0.371944484228473, 0.213749001076857, 0.215672279106258,
  0.232819778661784, 0.323687797395628, 0.42959546813244, 0.232241862009203,
  0.476351789125236, 0.371459108560162, 0.232345295869477, 0.23254363387734,
  0.197447624342202, 0.21474982562335, 0.233156638817423, 0.287456181650203,
  0.361173216640409, 0.190385452696744, 0.263289072269777, 0.232431515288679,
  0.262942705410463, 0.369426458802373, 0.214163564447386, 0.233329519140427,
  0.260945473747623, 0.23852011080998, 0.369936943362472, 0.23245738546371,
  0.231639138104731, 0.36970039346599, 0.295220053043484, 0.286264448698219,
  0.302574590320938, 0.276822365587971, 0.346229435804183, 0.214766127287707,
  0.231914533377091, 0.36964408127951, 0.232828411865577, 0.214472834876231,
  0.369542728285376, 0.397104331931522, 0.23283704529234, 0.232880215770661,
  0.317582287427801, 0.370511681545583, 0.368698568054849, 0.369520206959624,
  0.215010760130649, 0.400008928020172, 0.232750721058543, 0.361173216640409,
  0.239953993078001, 0.272294013558133, 0.231553123944497, 0.214025311699721,
  0.369734182480315, 0.231802626489789, 0.238783573078452, 0.299490457927026,
  0.26279659634823, 0.233493838026492, 0.423667395315982, 0.214790581469845,
  0.300023712356514, 0.233277645681801, 0.23316528071598, 0.311486597397749,
  0.370489135869965, 0.337313010320859, 0.214700926024228, 0.369204968089886,
  0.169331350414337, 0.231819840479545, 0.214554275772815, 0.452245724717689,
  0.294431010076932, 0.12827659875962, 0.255815001835487, 0.214741675128292,
  0.295799701621225, 0.369565250179164, 0.248956247913818, 0.239249510993205,
  0.369779236485003, 0.160603596899831, 0.347089006368348, 0.333711096617446,
  0.214562421098617, 0.240297942350326, 0.411878525508068, 0.299490457927026,
  0.214350715672961, 0.21459500464935, 0.369936943362472, 0.231974806550403,
  0.293592625651323, 0.311486597397749, 0.457500817903785, 0.47735939229444,
  0.214423981126502, 0.246697507436777, 0.214440264810723, 0.343436802397539,
  0.213559820998976, 0.21510050951896, 0.233294935943115, 0.368979865770324,
  0.231802626489789, 0.23929349955712, 0.256298942996098, 0.233147997141781,
  0.370320061302458, 0.380012703086237, 0.271494408723108, 0.382693526525954,
  0.214806885381669, 0.415614477133217, 0.377934032497953, 0.214318159092863,
  0.233346812076401, 0.194781684917557, 0.232698937221369, 0.279556400116815,
  0.340764497990907, 0.254762204661553, 0.214155430134709, 0.176258556703697,
  0.121088432295616, 0.331750173270276, 0.433373703969136, 0.368428606208023,
  0.273095090570347, 0.294119787902669, 0.232379780960633, 0.286629589697947,
  0.389394609101043, 0.265891001057586, 0.2683107596576, 0.240006886416344,
  0.21604861296176, 0.382339564334316, 0.312515467298546, 0.359311469377208,
  0.437530800182299, 0.2325177570115, 0.366260330870867, 0.255815001835487,
  0.369576511339047, 0.414633807489277, 0.224875630822797, 0.369306282711847,
  0.329235883754333, 0.371165751322682, 0.274701651161236, 0.274851911424338,
  0.471316823387952, 0.229127992442298, 0.315510419440878, 0.233096151769226,
  0.370816103375467, 0.239901107716827, 0.289421720642853, 0.323741177264386,
  0.214163564447386, 0.214611297773228, 0.296641741958112, 0.227127114825117,
  0.461265394211309, 0.369711656328916, 0.214978130731631, 0.232371159353273,
  0.443503580272444, 0.434990087636541, 0.214253056721096, 0.357280780070099,
  0.284158367051379, 0.246697507436777, 0.324626090711691, 0.238581567478475,
  0.293592625651323, 0.215010760130649, 0.232880215770661, 0.400008928020172,
  0.352656783713505, 0.214139162183645, 0.249097262126295, 0.273095090570347,
  0.232250480270722, 0.310300218859736, 0.214074099369918, 0.349895510961235,
  0.239962808080433, 0.250188503953077, 0.214529841143926, 0.369655343433018,
  0.239601574703534, 0.331696120559728, 0.369553989161271, 0.214310020509734,
  0.264364606535924, 0.388376763536027, 0.369114920325875, 0.368991119532943,
  0.214643886717997, 0.232284955547446, 0.232940663804656, 0.229127992442298,
  0.368608571626731, 0.392279505044733, 0.370060875386354, 0.214692776877661,
  0.214366995311559, 0.26279659634823, 0.241429168389052, 0.233441939160033,
  0.239091198065259, 0.368661537630019, 0.239857042676488, 0.181598759735883,
  0.254280173045383, 0.231727229247033, 0.297747461922618, 0.428606004600516,
  0.214480977954496, 0.237069818221134, 0.272443451547587, 0.400008928020172,
  0.370759721211097, 0.369497686201993, 0.370511681545583, 0.215639576894638,
  0.232681677726231, 0.496529529775724, 0.214790581469845, 0.266727830318417,
  0.347144264514679, 0.213846492803703, 0.232216008563053, 0.258128616158334,
  0.231475730281952, 0.373197945837601, 0.422681467838723, 0.278895258908529,
  0.23980417194121, 0.246087532313046, 0.240615733029875, 0.201194820815077,
  0.233156638817423, 0.383826480617341, 0.239998070306001, 0.232319434393133,
  0.401949251997194, 0.282003367509617, 0.369655343433018, 0.369936943362472,
  0.262160668307625, 0.238827502868948, 0.2325177570115, 0.335509660414896,
  0.278442453853321, 0.232448761848999, 0.331022310964137, 0.21492103793589,
  0.214912882721181, 0.233390048316752, 0.229127992442298, 0.231940363398388,
  0.214057835914126, 0.369835557181046, 0.368822328064257, 0.375266281735496,
  0.214033442416175, 0.214618427365765, 0.233961288814303, 0.277932326994668,
  0.369013627485735, 0.263726241532948, 0.341672433407, 0.305455537785086,
  0.240112697022856, 0.215451608953901, 0.364734474910827, 0.277932326994668,
  0.239003277486459, 0.238362129304879, 0.215729516628254, 0.370444046212349,
  0.232310814347126, 0.24072172703588, 0.370703342568612, 0.242688143977387,
  0.232009253272187, 0.334441915431711, 0.216499201469573, 0.370646967449329,
  0.239302297935107, 0.312515467298546, 0.274047623919981, 0.214823190192478,
  0.403833948421049, 0.369756709199038, 0.174140474088412, 0.238261904729849,
  0.281136987525367, 0.215459779001098, 0.370218631818535, 0.34680471038667,
  0.400189911785393, 0.352601122006445, 0.279254677929264, 0.214969973943728,
  0.283337487258274, 0.392459279167953, 0.318133125587485, 0.338616436517364,
  0.23984823033324, 0.369238738350008, 0.214163564447386, 0.368709818251041,
  0.370455318415024, 0.276822365587971, 0.292705155791175, 0.322857522896712,
  0.361931507716123, 0.214423981126502, 0.284463296358922, 0.302038758382724,
  0.229577022621107, 0.375266281735496, 0.250469735041162, 0.341335433161044,
  0.214244919936045, 0.239539937948443, 0.236069694254624, 0.332646210105489,
  0.417577815275616, 0.23984823033324, 0.370229901195812, 0.43629161536808,
  0.215533319538515, 0.364734474910827, 0.180401268362994, 0.214375135467994,
  0.239777739565428, 0.238528889668377, 0.29124148974262, 0.231303809091734,
  0.381682247945406, 0.370387687316734, 0.215051551936072, 0.296269143455305,
  0.23164774074818, 0.188640106426973, 0.232397024844485, 0.197929983066027,
  0.286629589697947, 0.214652034516066, 0.214082231434961, 0.231303809091734,
  0.23190592381623, 0.372429827779515, 0.313383915786465, 0.402920571049644,
  0.369238738350008, 0.370049608130883, 0.214635739144679, 0.245947663852229,
  0.214017181208033, 0.426628796568253, 0.231880096472385, 0.36903613600853,
  0.296269143455305, 0.108918438640676, 0.214757976343154, 0.196650677596175,
  0.315781463750501, 0.285286139430701, 0.370310999194684, 0.301722933436266,
  0.369948209202095, 0.368486052843686, 0.23297521044333, 0.349895510961235,
  0.370669517074174, 0.346400135249635, 0.199660096997108, 0.332313618660472,
  0.240412666984509, 0.369426458802373, 0.233260356312065, 0.418501130205651,
  0.214074099369918, 0.370849934364046, 0.303903929737124, 0.239663222320218,
  0.213259937159199, 0.231639138104731, 0.232129844909078, 0.314962024816509,
  0.435298498775606, 0.213830241934863, 0.440269116827838, 0.28580442126006,
  0.214635739144679, 0.231819840479545, 0.320378317885479, 0.294431010076932,
  0.208554668755289, 0.233701513717669, 0.232621276517659, 0.24064222854206,
  0.370038341016949, 0.213440490809015, 0.379777631085843, 0.233018398757939,
  0.240042153073459, 0.234099917516564, 0.376036744522677, 0.371253324573025,
  0.272443451547587, 0.329069384049474, 0.261380132287562, 0.248201800907025,
  0.407788455531309, 0.314638778415765, 0.283337487258274, 0.234932887018564,
  0.266727830318417, 0.219422573565295, 0.403101987114547, 0.214904727731216,
  0.398680620246535, 0.165949844210592, 0.369756709199038, 0.360999258164521,
  0.242221532242644, 0.215762228727455, 0.369632819267917, 0.216318884501916,
  0.370083410321868, 0.227836915802405, 0.249431562871286, 0.278442453853321,
  0.370962713475802, 0.238533994323685, 0.239381493314604, 0.300023712356514,
  0.237529616561535, 0.389998820289772, 0.375089520899818, 0.312031697103348,
  0.241480932292527, 0.369846821745508, 0.23916155049621, 0.385205165770244,
  0.213887123909263, 0.231837055361843, 0.137435323535853, 0.371064226705313,
  0.435543803631305, 0.231785413392586, 0.215035234539684, 0.238748433239178,
  0.371617109423376, 0.398013313499199, 0.317582287427801, 0.214074099369918,
  0.231819840479545, 0.318458293836737, 0.277631682171715, 0.233104792107347,
  0.217184540257398, 0.233545744915809, 0.369790500340675, 0.232849227141622,
  0.216277918539656, 0.239680837919879, 0.240468064616408, 0.214366995311559,
  0.397045957700519, 0.318133125587485, 0.412857274679967, 0.37118831389449,
  0.368698568054849, 0.238809930287242, 0.213708389076762, 0.368923599095416,
  0.216491002884528, 0.232371159353273, 0.235228389071004, 0.331418032802328,
  0.215206612036884, 0.232621276517659, 0.214310020509734, 0.233346812076401,
  0.282156068022782, 0.381917772910272, 0.297798447587083, 0.430033279750828,
  0.239117578563603, 0.371944484228473, 0.213749001076857, 0.215672279106258,
  0.239557547341533, 0.323687797395628, 0.402920571049644, 0.232241862009203,
  0.476351789125236, 0.23359765982766, 0.232345295869477, 0.23254363387734,
  0.197447624342202, 0.370207362582638, 0.215239266606463, 0.287456181650203,
  0.336242430319752, 0.23995989649081, 0.263289072269777, 0.369936943362472,
  0.262942705410463, 0.369426458802373, 0.214163564447386, 0.233329519140427,
  0.260945473747623, 0.23852011080998, 0.369936943362472, 0.23245738546371,
  0.231639138104731, 0.36970039346599, 0.237801130963547, 0.264364606535924,
  0.302574590320938, 0.333543459116722, 0.346229435804183, 0.214766127287707,
  0.231914533377091, 0.36964408127951, 0.214929193375341, 0.232345295869477,
  0.369542728285376, 0.397104331931522, 0.23283704529234, 0.232880215770661,
  0.317582287427801, 0.370511681545583, 0.368698568054849, 0.369520206959624,
  0.215010760130649, 0.400008928020172, 0.232750721058543, 0.361173216640409,
  0.21528825520282, 0.272294013558133, 0.231553123944497, 0.214025311699721,
  0.369734182480315, 0.231802626489789, 0.238783573078452, 0.299490457927026,
  0.26279659634823, 0.233493838026492, 0.33500764061403, 0.214790581469845,
  0.300023712356514, 0.233277645681801, 0.23316528071598, 0.311486597397749,
  0.370489135869965, 0.337313010320859, 0.370139750136828, 0.369204968089886,
  0.210436480856101, 0.231819840479545, 0.214554275772815, 0.452245724717689,
  0.294431010076932, 0.12827659875962, 0.255815001835487, 0.214741675128292,
  0.295799701621225, 0.369565250179164, 0.270048236917702, 0.239249510993205,
  0.369779236485003, 0.160603596899831, 0.347089006368348, 0.333711096617446,
  0.214562421098617, 0.233545744915809, 0.457253164365037, 0.299490457927026,
  0.214350715672961, 0.21459500464935, 0.369936943362472, 0.231974806550403,
  0.293592625651323, 0.311486597397749, 0.457500817903785, 0.47735939229444,
  0.214423981126502, 0.246697507436777, 0.232310814347126, 0.343436802397539,
  0.213559820998976, 0.21510050951896, 0.233294935943115, 0.368979865770324,
  0.231802626489789, 0.23929349955712, 0.256298942996098, 0.233147997141781,
  0.370320061302458, 0.380012703086237, 0.271494408723108, 0.382693526525954,
  0.214806885381669, 0.415614477133217, 0.377934032497953, 0.214318159092863,
  0.215418931012376, 0.194781684917557, 0.232698937221369, 0.279556400116815,
  0.340764497990907, 0.375032369773769, 0.214155430134709, 0.176258556703697,
  0.121088432295616, 0.331750173270276, 0.433373703969136, 0.368428606208023,
  0.273095090570347, 0.294119787902669, 0.232379780960633, 0.286629589697947,
  0.389394609101043, 0.265891001057586, 0.2683107596576, 0.215337251889514,
  0.21604861296176, 0.382339564334316, 0.312515467298546, 0.359311469377208,
  0.437530800182299, 0.2325177570115, 0.366260330870867, 0.255815001835487,
  0.369576511339047, 0.414633807489277, 0.224875630822797, 0.369306282711847,
  0.329235883754333, 0.371165751322682, 0.274701651161236, 0.274851911424338,
  0.471316823387952, 0.229127992442298, 0.315510419440878, 0.233096151769226,
  0.370816103375467, 0.239901107716827, 0.237529616561535, 0.323741177264386,
  0.214163564447386, 0.214611297773228, 0.296641741958112, 0.227127114825117,
  0.461265394211309, 0.369711656328916, 0.239619187200003, 0.232371159353273,
  0.443503580272444, 0.434990087636541, 0.214253056721096, 0.298329972357757,
  0.284158367051379, 0.267666332957724), .Dim = c(500L, 2L), .Dimnames = list(
    c("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11",
      "12", "13", "14", "15", "16", "17", "18", "19", "20", "21",
      "22", "23", "24", "25", "26", "27", "28", "29", "30", "31",
      "32", "33", "34", "35", "36", "37", "38", "39", "40", "41",
      "42", "43", "44", "45", "46", "47", "48", "49", "50", "51",
      "52", "53", "54", "55", "56", "57", "58", "59", "60", "61",
      "62", "63", "64", "65", "66", "67", "68", "69", "70", "71",
      "72", "73", "74", "75", "76", "77", "78", "79", "80", "81",
      "82", "83", "84", "85", "86", "87", "88", "89", "90", "91",
      "92", "93", "94", "95", "96", "97", "98", "99", "100", "101",
      "102", "103", "104", "105", "106", "107", "108", "109", "110",
      "111", "112", "113", "114", "115", "116", "117", "118", "119",
      "120", "121", "122", "123", "124", "125", "126", "127", "128",
      "129", "130", "131", "132", "133", "134", "135", "136", "137",
      "138", "139", "140", "141", "142", "143", "144", "145", "146",
      "147", "148", "149", "150", "151", "152", "153", "154", "155",
      "156", "157", "158", "159", "160", "161", "162", "163", "164",
      "165", "166", "167", "168", "169", "170", "171", "172", "173",
      "174", "175", "176", "177", "178", "179", "180", "181", "182",
      "183", "184", "185", "186", "187", "188", "189", "190", "191",
      "192", "193", "194", "195", "196", "197", "198", "199", "200",
      "201", "202", "203", "204", "205", "206", "207", "208", "209",
      "210", "211", "212", "213", "214", "215", "216", "217", "218",
      "219", "220", "221", "222", "223", "224", "225", "226", "227",
      "228", "229", "230", "231", "232", "233", "234", "235", "236",
      "237", "238", "239", "240", "241", "242", "243", "244", "245",
      "246", "247", "248", "249", "250", "251", "252", "253", "254",
      "255", "256", "257", "258", "259", "260", "261", "262", "263",
      "264", "265", "266", "267", "268", "269", "270", "271", "272",
      "273", "274", "275", "276", "277", "278", "279", "280", "281",
      "282", "283", "284", "285", "286", "287", "288", "289", "290",
      "291", "292", "293", "294", "295", "296", "297", "298", "299",
      "300", "301", "302", "303", "304", "305", "306", "307", "308",
      "309", "310", "311", "312", "313", "314", "315", "316", "317",
      "318", "319", "320", "321", "322", "323", "324", "325", "326",
      "327", "328", "329", "330", "331", "332", "333", "334", "335",
      "336", "337", "338", "339", "340", "341", "342", "343", "344",
      "345", "346", "347", "348", "349", "350", "351", "352", "353",
      "354", "355", "356", "357", "358", "359", "360", "361", "362",
      "363", "364", "365", "366", "367", "368", "369", "370", "371",
      "372", "373", "374", "375", "376", "377", "378", "379", "380",
      "381", "382", "383", "384", "385", "386", "387", "388", "389",
      "390", "391", "392", "393", "394", "395", "396", "397", "398",
      "399", "400", "401", "402", "403", "404", "405", "406", "407",
      "408", "409", "410", "411", "412", "413", "414", "415", "416",
      "417", "418", "419", "420", "421", "422", "423", "424", "425",
      "426", "427", "428", "429", "430", "431", "432", "433", "434",
      "435", "436", "437", "438", "439", "440", "441", "442", "443",
      "444", "445", "446", "447", "448", "449", "450", "451", "452",
      "453", "454", "455", "456", "457", "458", "459", "460", "461",
      "462", "463", "464", "465", "466", "467", "468", "469", "470",
      "471", "472", "473", "474", "475", "476", "477", "478", "479",
      "480", "481", "482", "483", "484", "485", "486", "487", "488",
      "489", "490", "491", "492", "493", "494", "495", "496", "497",
      "498", "499", "500"), NULL)), linpred = structure(c(-0.732592447300896,
        -1.16047179851293, -0.877998909140186, -1.29498193652102, -1.19211873560325,
        -0.110819745057266, -0.60738132738373, -1.30015363137724, -1.10343270207703,
        -0.978975618750803, -1.29870362347363, -0.420830145109252, -1.30054030015154,
        -0.619498532537004, -1.15288342381735, -1.09760718678796, -1.29783361873146,
        -0.533695676427542, -1.15486510128562, -0.700523729183274, -0.534130678798626,
        -1.29913862584471, -1.02340537097948, -0.454140557733367, -1.19816043520164,
        -0.536547358637982, -1.29715694837644, -1.19545375378156, -1.19178040042574,
        -1.21324158504744, -0.538190700928744, -0.437740455237892, -0.531955666943205,
        -1.29686694679572, -1.2988002906672, -1.03148350774832, -0.520065602133572,
        -1.292033587117, -1.15766844989927, -0.537963128257568, -1.19081372849,
        -1.50555309361486, -1.075913259977, -1.19858389639858, -0.858047396175838,
        -0.66542686965452, -0.532922338878948, -0.874203669713537, -0.982260650544286,
        -0.405427908162494, -0.528958983942403, -0.534372346782561, -0.53002232307172,
        -1.29126024956841, -1.19323040832936, -0.0138821038310733, -1.29628694363427,
        -1.0112881658262, -0.631615737690278, -1.16148680404546, -1.19584042255586,
        -1.05571791805487, -1.19999711187955, -0.518521822926386, -0.311775298729784,
        -0.949948103468889, -1.15375342855952, -1.22939785858514, -1.1493067376551,
        -1.37884338880885, -1.19057206050606, -0.473338034106773, -1.29309692624632,
        -1.19526041939442, -0.397349771393645, -0.934545866522132, -0.533695676427542,
        -0.532487336507863, -1.03476853954181, -1.15911845780289, -1.19414874666831,
        -0.793178473067267, -0.6841236266878, -1.19453541544261, -0.703564932018981,
        -0.530312324652443, -1.29556193968246, -0.527122307264492, -1.21324158504744,
        -1.19738709765305, -1.30063696734511, -0.532922338878948, -1.19941710871811,
        -0.509689649566595, -0.53558068670224, -1.6751939657607, -1.18607703600486,
        -0.954741208444255, -0.536450691444408, -1.02669040277296, -0.655850147996827,
        -0.82145195175824, -1.15206175267197, -1.29237192229451, -0.554873438386209,
        -0.954741208444255, -1.15815178586714, -1.1616801384326, -1.29072858000375,
        -0.530312324652443, -1.15795845148, -0.523932289876542, -0.529200651926339,
        -1.13799787063221, -1.19700042887875, -0.956239793333099, -0.520983940472527,
        -1.19158706603859, -1.15650844357638, -0.7883853680919, -0.974182513775437,
        -1.29609360924712, -0.574314743717391, -0.533260674056457, -1.55656239772354,
        -0.894155182677885, -0.938828763864332, -1.1519167518816, -0.531278996588185,
        -0.633114322579122, -0.404673871571553, -0.607625156341506, -0.570275675332966,
        -1.29522360450495, -0.927966314642126, -0.43698641864695, -0.762364510880713,
        -0.669465938038944, -1.2939185973917, -0.535484019508665, -1.30000863058688,
        -0.53775569855766, -0.530263991055656, -0.960278861717524, -0.882281806482386,
        -0.740670584069746, -0.566990643539483, -0.533260674056457, -1.19050575962973,
        -0.837608225295939, -0.942624003290981, -0.509689649566595, -1.09610860189912,
        -0.65734873288567, -1.29952529461901, -1.15520343646313, -1.17434948609203,
        -0.696240831841074, -0.33272467724285, -1.15351176057558, -0.531230662991398,
        -0.256226206896556, -1.29188858632664, -0.4450645554158, -1.13574524915243,
        -1.29875195707041, -1.19124873086108, -1.30116863690977, -0.999170960672927,
        -0.538819037686977, -0.48241403642434, -0.530553992636378, -1.29474026853708,
        -0.86512766739597, -1.19903043994381, -1.4588707199064, -1.19482541702333,
        -1.39928255968875, -0.911810041104427, -1.29710861477965, -1.30049196655475,
        -1.2009637838153, -1.1975804320402, -0.521806854719869, -0.784346299707475,
        -0.39331070300922, -0.535484019508665, -0.532004000539992, -1.29720528197323,
        -1.12034301220567, -1.30087863532905, -0.295619025192085, -1.19772543283056,
        -0.536354024250834, -0.86512766739597, -2.10183662962087, -1.29648027802142,
        -1.4073606964576, -0.773226960102919, -0.918389592984433, -1.09356811840354,
        -0.839106810184782, -0.532439002911076, -0.53871716484851, -1.19158706603859,
        -0.887575630797879, -0.5293456527167, -0.634900769483761, -1.38842011046654,
        -0.429662318469043, -1.1504184103812, -0.534678096464085, -1.18999205734462,
        -0.51372871795102, -1.30054030015154, -0.528572315168106, -0.828776051936147,
        -1.15452676610811, -1.30538612129826, -1.1990787735406, -1.19632375852373,
        -0.777022199529568, -0.554873438386209, -1.30199030805515, -0.534678096464085,
        -0.915849109488852, -1.29720528197323, -1.19806376800807, -0.752033752632078,
        -0.873959840755761, -1.33365959998924, -1.18752704390847, -0.531423997378547,
        -1.14916173686474, -0.532052334136779, -1.30431032070093, -1.05317743455929,
        -1.15399509654345, -1.15244842144626, -1.18530369845627, -0.506404617773112,
        -0.526843788653012, -0.982260650544286, -0.712397105378773, -1.03880760792623,
        -1.10822580705239, -0.373115361087097, -0.778520784418412, -0.927966314642126,
        -1.1806636731647, -1.0112881658262, -1.37884338880885, -0.207757386283459,
        -1.29561027327925, -0.410965561435763, -1.61460793999433, -1.29846195548969,
        -0.571029711923908, -1.14053835412779, -0.525333964183369, -0.533792343621116,
        -1.28724856103508, -1.29706028118287, -1.33037456819575, -0.723760273941105,
        -0.952200724948674, -0.528088979200235, -1.16073369604992, -1.1560734412053,
        -0.847184946953632, -1.16627134932318, -0.447317176895585, -0.510443686157537,
        -0.790637989571686, -1.14457742251222, -0.53287400528216, -1.19463208263618,
        -0.467512518817709, -1.30165197287764, -1.19796710081449, -1.56867960287681,
        -0.527653976829151, -0.259267409732263, -1.19825710239522, -1.29483693573066,
        -1.29996029699009, -0.525285630586582, -0.41374987388912, -0.764904994376294,
        -1.30054030015154, -1.30112030331298, -0.760865925991869, -0.956239793333099,
        -1.15351176057558, -1.28214957654043, -1.18839704865064, -1.15791011788321,
        -1.19229220653437, -1.28749022901901, -1.15443009891454, -0.772229094554201,
        -1.2988002906672, -0.417788942273544, -0.762364510880713, -0.352165982574031,
        -0.527122307264492, -0.537804032154447, -1.15921512499646, -1.30271531200696,
        -0.536837360218705, -1.28623355550255, -1.19497041781369, -1.17902033087394,
        -0.701778485114342, -1.19076539489321, -1.19356874350687, -1.29913862584471,
        -1.18950872137675, -0.93379182993119, -0.481416170875622, -0.857803567218062,
        -0.281715373134172, -0.532729004491799, -0.523883956279755, -1.30247364402302,
        -1.29106691518126, -1.19245707078076, -0.736875344643096, -0.283501820038811,
        -1.1956954217655, -0.0946634715195674, -0.525962300941601, -1.19511541860405,
        -1.19400374587795, -1.40232376252446, -1.29652861161821, -1.19057206050606,
        -0.907770972720002, -0.570275675332966, -1.44750755134407, -1.02894302425274,
        -1.19463208263618, -1.03072947115738, -0.534678096464085, -1.30000863058688,
        -1.18960538857032, -1.04106022940602, -1.16081013369044, -0.532487336507863,
        -1.19448708184582, -1.1990787735406, -0.533502342040393, -0.870164601329112,
        -0.913596488009066, -0.835067741800358, -0.960278861717524, -0.635654806074703,
        -1.29643194442463, -1.19753209844341, -0.533744010024329, -1.19240873718397,
        -1.29817195390897, -0.534179012395413, -0.417545113315769, -1.19236040358719,
        -1.19211873560325, -0.764904994376294, -0.53002232307172, -0.537804032154447,
        -0.534275679588987, -1.29498193652102, -0.405427908162494, -1.19284373955506,
        -0.570275675332966, -1.15293175741413, -0.983014687135228, -1.19956210950847,
        -1.30083030173226, -0.533357341250032, -1.19816043520164, -1.15936012578682,
        -0.849725430449213, -1.03148350774832, -1.18868705023137, -0.30773623034536,
        -1.29628694363427, -0.847184946953632, -1.18989539015104, -1.19052372690928,
        -0.793178473067267, -0.530118990265294, -0.675291453328008, -1.29681861319893,
        -0.535629020299027, -1.59037352968778, -1.19806376800807, -1.2976886179411,
        -0.191601112745761, -0.873959840755761, -1.91628331289511, -1.06783512320815,
        -1.29657694521499, -0.867380288875755, -0.534082345201839, -1.10418673866797,
        -1.1567984451571, -0.533164006862883, -1.65374386790751, -0.631859566648054,
        -0.691447726865707, -1.29764028434431, -1.15104674713944, -0.356205050958456,
        -0.849725430449213, -1.29889695786078, -1.29744694995716, -0.532487336507863,
        -1.1971937632659, -0.877998909140186, -0.793178473067267, -0.170407905274919,
        -0.0906244031351428, -1.29846195548969, -1.11630394382124, -1.29836528829612,
        -0.648015840185753, -1.30359967439362, -1.29445026695636, -1.18979872295747,
        -0.536595692234769, -1.19816043520164, -1.15655677717317, -1.06529463971257,
        -1.19062039410285, -0.530843994217101, -0.489494307644472, -0.987053755519653,
        -0.478131139082139, -1.2961902764407, -0.340802814011699, -0.498326481004263,
        -1.29909029224792, -1.18950872137675, -1.4192340726531, -1.19313374113578,
        -0.946663071675406, -0.659889216381251, -1.07337277648142, -1.30005696418367,
        -1.54190470907468, -1.98216316297698, -0.700279900225498, -0.268099583092054,
        -0.538964038477338, -0.978975618750803, -0.875458425644605, -1.19492208421691,
        -0.911810041104427, -0.449857660391166, -1.0155710631684, -1.00321002905735,
        -1.15264175583341, -1.28884356972905, -0.479629723970983, -0.7883853680919,
        -0.578353812101815, -0.251189272963414, -1.19414874666831, -0.548293886506203,
        -1.06783512320815, -0.534034011605051, -0.344841882396124, -1.23747599535398,
        -0.535194017927943, -0.711643068787831, -0.527218974458067, -0.970897481981954,
        -0.970143445391012, -0.114858813441691, -1.21324158504744, -0.774481716033987,
        -1.19091039568357, -0.528717315958467, -1.15322175899486, -0.898194251062309,
        -0.736631515685321, -1.30000863058688, -1.29735028276359, -0.863341220491331,
        -1.22460475360977, -0.155249497285938, -0.533454008443606, -1.29517527090817,
        -1.19497041781369, -0.226954862656865, -0.261520031212049, -1.29947696102222,
        -0.587185985461606, -0.923927246257701, -1.11630394382124, -0.732592447300896,
        -1.16047179851293, -0.877998909140186, -1.29498193652102, -1.19211873560325,
        -0.405427908162494, -0.60738132738373, -1.30015363137724, -1.10343270207703,
        -0.978975618750803, -1.19564708816871, -0.798716126340535, -1.30054030015154,
        -0.619498532537004, -1.15288342381735, -1.09760718678796, -1.29783361873146,
        -0.533695676427542, -1.15486510128562, -0.700523729183274, -0.534130678798626,
        -1.29913862584471, -1.02340537097948, -0.454140557733367, -0.536015689073324,
        -0.536547358637982, -1.29715694837644, -1.19545375378156, -1.19178040042574,
        -1.21324158504744, -0.538190700928744, -0.437740455237892, -0.531955666943205,
        -1.29686694679572, -1.2988002906672, -1.03148350774832, -1.14486004675068,
        -1.18897705181209, -1.15766844989927, -0.537963128257568, -1.15346342697879,
        -1.50555309361486, -1.075913259977, -1.19858389639858, -0.858047396175838,
        -0.287540888423236, -1.29812362031218, -1.16881183281876, -0.982260650544286,
        -0.405427908162494, -0.528958983942403, -0.534372346782561, -0.53002232307172,
        -1.29126024956841, -1.19323040832936, -0.0138821038310733, -1.29628694363427,
        -1.0112881658262, -0.631615737690278, -1.30189364086158, -1.19584042255586,
        -1.05571791805487, -1.19999711187955, -0.518521822926386, -0.311775298729784,
        -0.949948103468889, -1.15375342855952, -1.11958897561473, -1.1493067376551,
        -1.37884338880885, -1.19057206050606, -0.473338034106773, -1.1526900894302,
        -1.19526041939442, -0.397349771393645, -0.934545866522132, -0.533695676427542,
        -0.532487336507863, -1.03476853954181, -1.15911845780289, -1.19414874666831,
        -0.683369590096858, -0.952200724948674, -1.19453541544261, -0.703564932018981,
        -1.29551360608568, -1.29556193968246, -1.18926705339281, -1.21324158504744,
        -1.19738709765305, -1.30063696734511, -0.532922338878948, -0.537272362589789,
        -0.509689649566595, -1.30078196813547, -1.29730798452941, -1.18607703600486,
        -0.954741208444255, -0.536450691444408, -1.02669040277296, -0.655850147996827,
        -0.82145195175824, -1.15206175267197, -1.29237192229451, -0.554873438386209,
        -0.954741208444255, -1.15815178586714, -1.1616801384326, -1.29072858000375,
        -0.530312324652443, -1.1953087529912, -1.14872673449365, -0.529200651926339,
        -1.13799787063221, -1.19700042887875, -0.688162695072224, -1.28618522190576,
        -0.529442319910274, -1.15650844357638, -0.7883853680919, -0.974182513775437,
        -1.29609360924712, -0.389515463582571, -0.533260674056457, -1.55656239772354,
        -1.16223228093876, -0.938828763864332, -1.29232358869773, -0.531278996588185,
        -0.633114322579122, -0.404673871571553, -0.607625156341506, -0.94816165656425,
        -1.29522360450495, -0.927966314642126, -0.43698641864695, -0.762364510880713,
        -0.669465938038944, -1.15351176057558, -0.535484019508665, -1.30000863058688,
        -0.53775569855766, -0.530263991055656, -0.960278861717524, -0.882281806482386,
        -0.740670584069746, -0.566990643539483, -1.29846195548969, -0.922428661368857,
        -0.837608225295939, -1.21070110155186, -0.509689649566595, -1.09610860189912,
        -0.65734873288567, -1.29952529461901, -1.15520343646313, -1.17434948609203,
        -0.696240831841074, -0.33272467724285, -1.15351176057558, -0.531230662991398,
        -0.256226206896556, -1.29188858632664, -0.554873438386209, -1.51363123038371,
        -1.29875195707041, -1.15389842934988, -1.16076180009365, -0.889362077702518,
        -1.2009637838153, -0.48241403642434, -0.530553992636378, -1.29474026853708,
        -0.86512766739597, -1.19903043994381, -1.4588707199064, -1.19482541702333,
        -1.39928255968875, -0.911810041104427, -1.29710861477965, -1.30049196655475,
        -1.2009637838153, -1.1975804320402, -0.521806854719869, -0.784346299707475,
        -0.39331070300922, -0.535484019508665, -0.532004000539992, -1.29720528197323,
        -1.12034301220567, -1.30087863532905, -0.295619025192085, -1.19772543283056,
        -0.536354024250834, -0.86512766739597, -2.10183662962087, -1.29648027802142,
        -1.4073606964576, -0.773226960102919, -0.918389592984433, -0.530882857037436,
        -0.839106810184782, -0.532439002911076, -0.53871716484851, -1.19158706603859,
        -0.619498532537004, -0.5293456527167, -0.634900769483761, -1.38842011046654,
        -0.697739416729917, -1.1504184103812, -0.534678096464085, -1.18999205734462,
        -0.328929437816201, -1.30054030015154, -0.528572315168106, -0.828776051936147,
        -1.15452676610811, -1.30538612129826, -1.1990787735406, -1.19632375852373,
        -0.777022199529568, -0.260265275280981, -1.30199030805515, -0.240069933358857,
        -0.915849109488852, -1.29720528197323, -1.19806376800807, -0.752033752632078,
        -0.873959840755761, -1.33365959998924, -1.18752704390847, -1.19356874350687,
        -1.14916173686474, -0.532052334136779, -1.30431032070093, -0.490492173193189,
        -1.19134539805466, -1.15244842144626, -1.18530369845627, -0.506404617773112,
        -0.526843788653012, -0.982260650544286, -0.712397105378773, -1.03880760792623,
        -1.10822580705239, -0.373115361087097, -0.778520784418412, -0.927966314642126,
        -1.1806636731647, -1.0112881658262, -1.26903450583844, -0.392556666418279,
        -1.29561027327925, -0.410965561435763, -1.61460793999433, -0.533260674056457,
        -0.571029711923908, -1.14053835412779, -1.2905352456166, -0.533792343621116,
        -1.28724856103508, -0.531858999749631, -1.22056568522534, -1.10164625517239,
        -0.952200724948674, -0.528088979200235, -1.16073369604992, -1.1560734412053,
        -0.847184946953632, -1.16627134932318, -0.447317176895585, -0.510443686157537,
        -0.790637989571686, -1.14457742251222, -0.53287400528216, -1.15728178112498,
        -0.467512518817709, -1.30165197287764, -1.19796710081449, -1.83675670113769,
        -0.527653976829151, -0.259267409732263, -1.19825710239522, -1.29483693573066,
        -1.15955346017397, -0.525285630586582, -0.41374987388912, -0.764904994376294,
        -1.30054030015154, -1.19806376800807, -0.760865925991869, -0.956239793333099,
        -1.19086206208679, -1.28214957654043, -1.18839704865064, -0.533115673266096,
        -1.19229220653437, -1.28749022901901, -1.15443009891454, -1.15011507578548,
        -1.2988002906672, -0.417788942273544, -0.762364510880713, -0.352165982574031,
        -0.527122307264492, -0.537804032154447, -1.15921512499646, -1.30271531200696,
        -0.536837360218705, -1.28623355550255, -1.19497041781369, -1.17902033087394,
        -0.701778485114342, -1.29382193019813, -1.19356874350687, -1.29913862584471,
        -1.18950872137675, -0.93379182993119, -0.481416170875622, -0.857803567218062,
        -0.281715373134172, -1.15752344910891, -0.523883956279755, -1.30247364402302,
        -1.29106691518126, -1.15510676926956, -0.736875344643096, -0.39331070300922,
        -1.1956954217655, -0.0946634715195674, -1.18810704706992, -1.19511541860405,
        -1.19400374587795, -1.40232376252446, -0.531327330184972, -1.29362859581098,
        -0.907770972720002, -0.680084558303375, -1.15289938823884, -1.02894302425274,
        -0.532487336507863, -1.03072947115738, -0.534678096464085, -1.30000863058688,
        -1.18960538857032, -1.04106022940602, -1.16081013369044, -0.532487336507863,
        -1.19448708184582, -1.1990787735406, -0.533502342040393, -1.16477276443434,
        -1.02340537097948, -0.835067741800358, -0.692201763456649, -0.635654806074703,
        -1.29643194442463, -1.19753209844341, -0.533744010024329, -1.29546527248889,
        -1.19511541860405, -0.534179012395413, -0.417545113315769, -1.19236040358719,
        -1.19211873560325, -0.764904994376294, -0.53002232307172, -0.537804032154447,
        -0.534275679588987, -1.29498193652102, -0.405427908162494, -1.19284373955506,
        -0.570275675332966, -1.29333859423026, -0.983014687135228, -1.19956210950847,
        -1.30083030173226, -0.533357341250032, -1.19816043520164, -1.15936012578682,
        -0.849725430449213, -1.03148350774832, -1.18868705023137, -0.685622211576643,
        -1.29628694363427, -0.847184946953632, -1.18989539015104, -1.19052372690928,
        -0.793178473067267, -0.530118990265294, -0.675291453328008, -0.531617331765695,
        -0.535629020299027, -1.3222964314269, -1.19806376800807, -1.2976886179411,
        -0.191601112745761, -0.873959840755761, -1.91628331289511, -1.06783512320815,
        -1.29657694521499, -0.867380288875755, -0.534082345201839, -0.99437785569756,
        -1.1567984451571, -0.533164006862883, -1.65374386790751, -0.631859566648054,
        -0.691447726865707, -1.29764028434431, -1.18839704865064, -0.171405770823637,
        -0.849725430449213, -1.29889695786078, -1.29744694995716, -0.532487336507863,
        -1.1971937632659, -0.877998909140186, -0.793178473067267, -0.170407905274919,
        -0.0906244031351428, -1.29846195548969, -1.11630394382124, -1.1953087529912,
        -0.648015840185753, -1.30359967439362, -1.29445026695636, -1.18979872295747,
        -0.536595692234769, -1.19816043520164, -1.15655677717317, -1.06529463971257,
        -1.19062039410285, -0.530843994217101, -0.489494307644472, -0.987053755519653,
        -0.478131139082139, -1.2961902764407, -0.340802814011699, -0.498326481004263,
        -1.29909029224792, -1.29256525668166, -1.4192340726531, -1.19313374113578,
        -0.946663071675406, -0.659889216381251, -0.510687515115313, -1.30005696418367,
        -1.54190470907468, -1.98216316297698, -0.700279900225498, -0.268099583092054,
        -0.538964038477338, -0.978975618750803, -0.875458425644605, -1.19492208421691,
        -0.911810041104427, -0.449857660391166, -1.0155710631684, -1.00321002905735,
        -1.29304859264953, -1.28884356972905, -0.479629723970983, -0.7883853680919,
        -0.578353812101815, -0.251189272963414, -1.19414874666831, -0.548293886506203,
        -1.06783512320815, -0.534034011605051, -0.344841882396124, -1.23747599535398,
        -0.535194017927943, -0.711643068787831, -0.527218974458067, -0.970897481981954,
        -0.970143445391012, -0.114858813441691, -1.21324158504744, -0.774481716033987,
        -1.19091039568357, -0.528717315958467, -1.15322175899486, -1.16627134932318,
        -0.736631515685321, -1.30000863058688, -1.29735028276359, -0.863341220491331,
        -1.22460475360977, -0.155249497285938, -0.533454008443606, -1.15476843409205,
        -1.19497041781369, -0.226954862656865, -0.261520031212049, -1.29947696102222,
        -0.855263083722481, -0.923927246257701, -1.00649506085083), .Dim = c(500L,
          2L), .Dimnames = list(c("1", "2", "3", "4", "5", "6", "7", "8",
            "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19",
            "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30",
            "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41",
            "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52",
            "53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63",
            "64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74",
            "75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85",
            "86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96",
            "97", "98", "99", "100", "101", "102", "103", "104", "105", "106",
            "107", "108", "109", "110", "111", "112", "113", "114", "115",
            "116", "117", "118", "119", "120", "121", "122", "123", "124",
            "125", "126", "127", "128", "129", "130", "131", "132", "133",
            "134", "135", "136", "137", "138", "139", "140", "141", "142",
            "143", "144", "145", "146", "147", "148", "149", "150", "151",
            "152", "153", "154", "155", "156", "157", "158", "159", "160",
            "161", "162", "163", "164", "165", "166", "167", "168", "169",
            "170", "171", "172", "173", "174", "175", "176", "177", "178",
            "179", "180", "181", "182", "183", "184", "185", "186", "187",
            "188", "189", "190", "191", "192", "193", "194", "195", "196",
            "197", "198", "199", "200", "201", "202", "203", "204", "205",
            "206", "207", "208", "209", "210", "211", "212", "213", "214",
            "215", "216", "217", "218", "219", "220", "221", "222", "223",
            "224", "225", "226", "227", "228", "229", "230", "231", "232",
            "233", "234", "235", "236", "237", "238", "239", "240", "241",
            "242", "243", "244", "245", "246", "247", "248", "249", "250",
            "251", "252", "253", "254", "255", "256", "257", "258", "259",
            "260", "261", "262", "263", "264", "265", "266", "267", "268",
            "269", "270", "271", "272", "273", "274", "275", "276", "277",
            "278", "279", "280", "281", "282", "283", "284", "285", "286",
            "287", "288", "289", "290", "291", "292", "293", "294", "295",
            "296", "297", "298", "299", "300", "301", "302", "303", "304",
            "305", "306", "307", "308", "309", "310", "311", "312", "313",
            "314", "315", "316", "317", "318", "319", "320", "321", "322",
            "323", "324", "325", "326", "327", "328", "329", "330", "331",
            "332", "333", "334", "335", "336", "337", "338", "339", "340",
            "341", "342", "343", "344", "345", "346", "347", "348", "349",
            "350", "351", "352", "353", "354", "355", "356", "357", "358",
            "359", "360", "361", "362", "363", "364", "365", "366", "367",
            "368", "369", "370", "371", "372", "373", "374", "375", "376",
            "377", "378", "379", "380", "381", "382", "383", "384", "385",
            "386", "387", "388", "389", "390", "391", "392", "393", "394",
            "395", "396", "397", "398", "399", "400", "401", "402", "403",
            "404", "405", "406", "407", "408", "409", "410", "411", "412",
            "413", "414", "415", "416", "417", "418", "419", "420", "421",
            "422", "423", "424", "425", "426", "427", "428", "429", "430",
            "431", "432", "433", "434", "435", "436", "437", "438", "439",
            "440", "441", "442", "443", "444", "445", "446", "447", "448",
            "449", "450", "451", "452", "453", "454", "455", "456", "457",
            "458", "459", "460", "461", "462", "463", "464", "465", "466",
            "467", "468", "469", "470", "471", "472", "473", "474", "475",
            "476", "477", "478", "479", "480", "481", "482", "483", "484",
            "485", "486", "487", "488", "489", "490", "491", "492", "493",
            "494", "495", "496", "497", "498", "499", "500"), NULL)))

mice.options <- NULL
mice.options$seed <- as.vector(matrix(seeds,ncol=1,nrow=5*5))[1:2]
mice.options$maxit <- 2

set.seed(12345)
test_that("output replicates from specified seed for mipred and rubin method",{
  expect_equal(mipred.cv(Status~age10+cyto,family=binomial,data=cll_bin[1:500,-1], nimp=2, folds=2, mice.options=mice.options, method="rubin")[2:3],output)
})
