library(mirai)
nanotest <- function(x) invisible(x || stop())
nanotestn <- function(x) invisible(is.null(x) || stop())
nanotesterr <- function(x, e = "")
  invisible(grepl(e, tryCatch(x, error = identity)[["message"]], fixed = TRUE) || stop())

nanotest(is.list(daemons()))
nanotest(daemons()[["connections"]] == 0L)
nanotest(daemons()[["daemons"]] == 0L)
n <- 3L
m <- mirai({
  Sys.sleep(0.1)
  q <- m + n + 1L
  q / m
}, m = 2L, .args = list(n))
b <- m$data %>>% rnorm %>>% as.character()
b
nanotest(inherits(call_mirai(m), "mirai"))
nanotest(m$data == 3L)
nanotest(identical(call_mirai(m), m))
nanotest(is_mirai(m))
nanotest(length(b) == 3L || length(b$data) == 3L)
nanotest(is.character(b) || is.character(b$data))
Sys.sleep(2.2)
nanotest(daemons(1L, dispatcher = FALSE) == 1L)
me <- mirai(mirai())
nanotest(is_mirai_error(call_mirai(me)$data))
nanotest(!is_mirai_interrupt(me$data))
nanotest(is_error_value(me[["data"]]))
df <- data.frame(a = 1, b = 2)
dm <- mirai(as.matrix(df), .args = list(df), .timeout = 1000L)
nanotest(is_mirai(call_mirai(dm)))
nanotest(!unresolved(dm))
nanotest(is.matrix(dm$data))
nanotestn(stop_mirai(dm))
nanotest(daemons()[["daemons"]] == 1L)
nanotest(daemons(0L) == 0L)
nanotest(daemons()[["daemons"]] == 0L)
Sys.sleep(0.2)
if (Sys.info()[["sysname"]] != "Windows" || length(R.version$crt)) {
  nanotest(daemons(url = value <- sprintf(mirai:::.urlfmt, runif(1, 1000000, 9999999)), dispatcher = FALSE) == value)
  nanotest(daemons(0L) == 0L)
  Sys.sleep(0.2)
  nanotest(daemons(url = value <- "ws://:0", dispatcher = FALSE) != value)
  nanotest(daemons(0L) == 0L)
  Sys.sleep(0.2)
  nanotest(daemons(1L, dispatcher = FALSE, walltime = 500L, timerstart = 1L, .compute = "new") == 1L)
  mn <- mirai("test", .compute = "new")
  mp <- mirai("test2", .compute = "new")
  nanotest(call_mirai(mn)$data == "test")
  nanotest(call_mirai(mp)$data == "test2")
  nanotest(daemons(.compute = "new")[["connections"]] == 1L)
  Sys.sleep(0.8)
  nanotest(daemons(.compute = "new")[["connections"]] == 0L)
  nanotest(daemons(0L, .compute = "new") == 0L)
}
if (Sys.getenv("NOT_CRAN") == "set") {
  nanotest(daemons(1, dispatcher = TRUE, maxtasks = 10L) == 1L)
  mq <- mirai("server")
  nanotest(call_mirai(mq)$data == "server")
  nanotest(is.matrix(daemons()[["daemons"]]))
  nanotest(daemons(0) == 0L)
  Sys.sleep(0.2)
  nanotest(daemons(n = 2, "ws://:0") == 2L)
  nanotest(is.matrix(nodes <- daemons()[["daemons"]]) || is_error_value(nodes))
  nanotest(daemons(0) == 0L)
  Sys.sleep(0.2)
}
nanotesterr(daemons(url = "URL"), "argument")
nanotesterr(daemons(-1), "zero or greater")
nanotesterr(daemons(raw(0L)), "must be numeric")
nanotesterr(server("URL"), "argument")
nanotest(daemons(0L) == 0L)
nanotest(is_mirai_interrupt(r <- mirai:::mk_interrupt_error()))
me$data
m
b
r

