% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empirical_rxx.R
\name{empirical_rxx}
\alias{empirical_rxx}
\title{Function to calculate the empirical (marginal) reliability}
\usage{
empirical_rxx(Theta_SE)
}
\arguments{
\item{Theta_SE}{a matrix of latent trait estimates returned from \code{\link{fscores}} with the options
\code{full.scores = TRUE} and \code{full.scores.SE = TRUE}}
}
\description{
Given secondary latent trait estimates and their associated standard errors
returned from \code{\link{fscores}}, compute the empirical reliability.
}
\examples{

\dontrun{

dat <- expand.table(deAyala)
mod <- mirt(dat, 1)

theta_se <- fscores(mod, full.scores.SE = TRUE)
empirical_rxx(theta_se)

theta_se <- fscores(mod, full.scores.SE = TRUE, method = 'ML')
empirical_rxx(theta_se)

}
}
\seealso{
\code{\link{fscores}}, \code{\link{marginal_rxx}}
}
\keyword{reliability}

