% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{thetaComb}
\alias{thetaComb}
\title{Create all possible combinations of vector input}
\usage{
thetaComb(theta, nfact, intercept = FALSE)
}
\arguments{
\item{theta}{the vector from which all possible combinations should be obtained}

\item{nfact}{the number of observations (and therefore the number of columns to return in
the matrix of combinations)}

\item{intercept}{logical; should a vector of 1's be appended to the first column of the
result to include an intercept design component? Default is \code{FALSE}}
}
\value{
a matrix with all possible combinations
}
\description{
This function constructs all possible k-way combinations of an input vector.
It is primarily useful when used in conjunction with the \code{\link{mdirt}} function,
though users may have other uses for it as well. See \code{\link{expand.grid}} for more
flexible combination formats.
}
\examples{

# all possible joint combinations for the vector -4 to 4
thetaComb(-4:4, 2)

# all possible binary combinations for four observations
thetaComb(c(0,1), 4)

# all possible binary combinations for four observations (with intercept)
thetaComb(c(0,1), 4, intercept=TRUE)

}
\references{
Chalmers, R., P. (2012). mirt: A Multidimensional Item Response Theory
Package for the R Environment. \emph{Journal of Statistical Software, 48}(6), 1-29.
\doi{10.18637/jss.v048.i06}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
