% Generated by roxygen2 (4.0.1): do not edit by hand
\name{wald}
\alias{wald}
\title{Wald test for mirt models}
\usage{
wald(object, L, C = 0)
}
\arguments{
\item{L}{a coefficient matrix with dimensions nconstrasts x npars.
Omitting this value will return the column names of the
information matrix used to identify the (potentially constrained) parameters}

\item{object}{estimated object from \code{mirt}, \code{bfactor},
\code{multipleGroup}, or \code{mixedmirt}}

\item{C}{a constant vector of population parameters to be compared along side L, where
\code{length(C) == ncol(L)}. By default a vector of 0's is constructed}
}
\description{
Compute a Wald test given an \code{L} vector or matrix of numeric contrasts. Requires that the
model information matrix be computed (including \code{SE = TRUE} when using the EM method). Use
\code{wald(model)} to observe how the information matrix columns are named, especially if
the estimated model contains constrained parameters (e.g., 1PL).
}
\examples{
\dontrun{
#View parnumber index
data(LSAT7)
data <- expand.table(LSAT7)
mod <- mirt(data, 1, SE = TRUE)
coef(mod)

# see how the information matrix relates to estimated parameters, and how it lines up
#   with the parameter index
(infonames <- wald(mod))
index <- mod2values(mod)
index[index$est, ]

#second item slope equal to 0?
L <- matrix(0, 1, 10)
L[1,3] <- 1
wald(mod, L)

#simultaneously test equal factor slopes for item 1 and 2, and 4 and 5
L <- matrix(0, 2, 10)
L[1,1] <- L[2, 7] <- 1
L[1,3] <- L[2, 9] <- -1
L
wald(mod, L)

#logLiklihood tests (requires estimating a new model)
cmodel <- mirt.model('theta = 1-5
                      CONSTRAIN = (1,2, a1), (4,5, a1)')
mod2 <- mirt(data, cmodel)
#or, eqivalently
#mod2 <- mirt(data, 1, constrain = list(c(1,5), c(13,17)))
anova(mod2, mod)

}
}
\keyword{wald}

