context('mirtTwo')

test_that('poly', {
    modp1 <- mirt(Science, 1, verbose=FALSE)
    expect_is(modp1, 'ConfirmatoryClass')
    expect_equal(modp1@df, 239)
    cfs <- as.numeric(do.call(c, coef(modp1)))
    expect_equal(cfs, c(1.041, 4.864, 2.64, -1.466, 1.226, 2.924, 0.901, -2.266, 2.296, 5.238, 2.216, -1.965, 1.095, 3.348, 0.992, -1.688, 0, 1),
                 tolerance = 1e-2)
    modLouis <- mirt(Science, 1, SE=T, SE.type='Louis', verbose=FALSE)
    expect_is(modp1, 'ConfirmatoryClass')
    cfs <- as.numeric(do.call(c, coef(modLouis, digits = 5, printSE=TRUE)))
    expect_equal(cfs, c(1.04236, 0.18838, 4.86544, 0.49088, 2.64044, 0.22267, -1.46621, 0.15868, 1.22569, 0.18189, 2.924, 0.23928, 0.90115, 0.14289, -2.26661, 0.20308, 2.29058, 0.48269, 5.22988, 0.72817, 2.21201, 0.3564, -1.96222, 0.32209, 1.09557, 0.18336, 3.34845, 0.27659, 0.9919, 0.14053, -1.68846, 0.16864, 0, NA, 1, NA),
                 tolerance = 1e-3)
    expect_equal(modLouis@condnum, 97.04485, tolerance = 1e-2)
    modsandwich <- mirt(Science, 1, SE=T, SE.type='sandwich', verbose=FALSE)
    expect_is(modp1, 'ConfirmatoryClass')
    cfs <- as.numeric(do.call(c, coef(modsandwich, digits = 5, printSE=TRUE)))
    expect_equal(cfs, c(1.04236, 0.23843, 4.86544, 0.46794, 2.64044, 0.24659, -1.46621, 0.17162, 1.22569, 0.1922, 2.924, 0.24655, 0.90115, 0.14592, -2.26661, 0.19899, 2.29058, 0.52026, 5.22988, 0.80736, 2.21201, 0.373, -1.96222, 0.33683, 1.09557, 0.22701, 3.34845, 0.29203, 0.9919, 0.14491, -1.68846, 0.18015, 0, NA, 1, NA),
                 tolerance = 1e-3)
    expect_equal(modsandwich@condnum, 140.0871, tolerance = 1e-2)
    modp1 <- mirt(Science, 1, verbose=FALSE)
    expect_is(modp1, 'ConfirmatoryClass')
    expect_equal(modp1@df, 239)
    cfs <- as.numeric(do.call(c, coef(modp1)))
    expect_equal(cfs, c(1.041, 4.864, 2.64, -1.466, 1.226, 2.924, 0.901, -2.266, 2.296, 5.238, 2.216, -1.965, 1.095, 3.348, 0.992, -1.688, 0, 1),
                 tolerance = 1e-2)
    vals <- mirt(Science, 1, large = TRUE, verbose=FALSE)
    modp1 <- mirt(Science, 1, large = vals, verbose=FALSE)
    expect_is(modp1, 'ConfirmatoryClass')
    cfs <- as.numeric(do.call(c, coef(modp1)))
    expect_equal(cfs, c(1.041, 4.864, 2.64, -1.466, 1.226, 2.924, 0.901, -2.266, 2.296, 5.238, 2.216, -1.965, 1.095, 3.348, 0.992, -1.688, 0, 1),
                 tolerance = 1e-2)
    modp1 <- mirt(Science, 1, SE=TRUE, SE.type = 'SEM', verbose=FALSE)
    expect_is(modp1, 'ConfirmatoryClass')
    expect_equal(modp1@condnum, 102.5529, tolerance = 1e-2)
    cfs <- as.numeric(do.call(c, coef(modp1)))
    expect_equal(cfs, c(1.041, 0.656, 1.425, 4.863, 3.849, 5.876, 2.639, 2.196, 3.083, -1.466, -1.782, -1.149, 1.226, 0.887, 1.565, 2.924, 2.45, 3.398, 0.901, 0.614, 1.188, -2.266, -2.639, -1.894, 2.3, 1.325, 3.275, 5.244, 3.804, 6.685, 2.218, 1.488, 2.949, -1.967, -2.605, -1.329, 1.094, 0.727, 1.461, 3.347, 2.801, 3.893, 0.991, 0.717, 1.266, -1.688, -2.018, -1.357, 0, NA, NA, 1, NA, NA),
                 tolerance = 1e-2)
    modp2 <- mirt(Science, 2, verbose=FALSE)
    expect_is(modp2, 'ExploratoryClass')
    expect_equal(modp2@df, 236)
    cfs <- as.numeric(do.call(c, coef(modp2, digits=4, verbose=FALSE)))
    expect_equal(abs(cfs), abs(c(1.3248, -0.0373, 5.2047, 2.8665, -1.605, -0.1116, -2.4002, 4.02, 1.2556, -3.1606, 0.9372, -1.1447, 4.5539, 1.9064, -1.6944, 1.7547, 0.0843, 3.9762, 1.1913, -2.0395, 0, 0, 1, -0.4825, 1)),
                 tolerance = 1e-2)
    modp3 <- mirt(Science, 1, constrain = list(c(1,5)), parprior = list(c(2,'norm',0,1)), verbose=FALSE)
    expect_is(modp3, 'ConfirmatoryClass')
    cfs <- as.numeric(do.call(c, coef(modp3, verbose = FALSE)))
    expect_true(mirt:::closeEnough(cfs - c(1.090,  4.248,  2.550, -1.507,  1.090,  2.817,  0.853, -2.198,  2.269,
                        5.176,  2.173, -1.978,  1.121,  3.357,  0.987, -1.714,  0.000,  1.000),
                 -1e-2, 1e-2))
    newmodel <- mirt.model('F = 1-4
                           CONSTRAIN = (1-2,a1)
                           PRIOR = (1, d1, norm, 0, 1)')
    modp3 <- mirt(Science, newmodel, verbose=FALSE)
    expect_is(modp3, 'ConfirmatoryClass')
    cfs <- as.numeric(do.call(c, coef(modp3, verbose = FALSE)))
    expect_true(mirt:::closeEnough(cfs - c(1.090,  4.248,  2.550, -1.507,  1.090,  2.817,  0.853, -2.198,  2.269,
                                           5.176,  2.173, -1.978,  1.121,  3.357,  0.987, -1.714,  0.000,  1.000),
                                   -1e-2, 1e-2))

    modp4 <- mirt(Science, 1, itemtype = c(rep('graded',3), 'nominal'), verbose=FALSE)
    expect_is(modp4, 'ConfirmatoryClass')
    cfs <- as.numeric(do.call(c, coef(modp4, verbose = FALSE, digits=4)))
    expect_equal(cfs, c(1.0408, 4.862, 2.6387, -1.4664, 1.2063, 2.9083, 0.8958, -2.254, 2.3376, 5.2972, 2.2404, -1.9886, 0.7986, 0, 1.0782, 1.7756, 3, 0, 2.1964, 2.9637, 1.6742, 0, 1),
                 tolerance = 1e-2)
    modp5 <- mirt(Science, 1, itemtype = c(rep('graded',3), 'gpcm'), SE = TRUE, SE.type = 'SEM', verbose=FALSE)
    expect_is(modp5, 'ConfirmatoryClass')
    cfs <- as.numeric(do.call(c, coef(modp5, verbose = FALSE)))
    expect_equal(cfs, c(1.057, 0.676, 1.438, 4.876, 3.912, 5.84, 2.65, 2.21, 3.09, -1.472, -1.786, -1.159, 1.219, 0.839, 1.599, 2.918, 2.425, 3.41, 0.9, 0.615, 1.185, -2.263, -2.679, -1.848, 2.254, 1.322, 3.187, 5.177, 3.765, 6.588, 2.19, 1.49, 2.89, -1.942, -2.567, -1.318, 0.771, 0.464, 1.077, 0, NA, NA, 1, NA, NA, 2, NA, NA, 3, NA, NA, 0, NA, NA, 2.16, 1.552, 2.767, 2.973, 2.29, 3.657, 1.767, 1.137, 2.397, 0, NA, NA, 1, NA, NA),
                 tolerance = 1e-2)
    modp6 <- mirt(Science, 1, empiricalhist=TRUE, verbose = FALSE)
    expect_is(modp6, 'ConfirmatoryClass')
    cfs <- as.numeric(do.call(c, coef(modp6, verbose = FALSE)))
    expect_equal(cfs, c(0.789, 5.158, 2.624, -1.344, 1.047, 2.943, 0.962, -2.184, 2.681, 5.726, 2.782, -1.808, 0.931, 3.423, 1.047, -1.592, 0, 1),
                 tolerance = 1e-2)
    
    fm0 <- fscores(modp1, method='EAP', response.pattern = c(1,2,3,4))
    expect_equal(as.numeric(fm0[,c('F1','SE_F1')]), c(-0.3494903, 0.6004922), tolerance=1e-4)
    fm1 <- fscores(modp1, verbose = FALSE)
    expect_is(fm1, 'matrix')
    expect_true(mirt:::closeEnough(fm1[1:6,'F1'] - c(-2.7488324, -1.4190140, -0.7154329, -0.4453752, -2.5438490, -1.2481072), -1e-2, 1e-2))
    fm1b <- fscores(modp1, verbose = FALSE, full.scores=TRUE)
    expect_equal(cor(fm1b, rowSums(Science))[1], .969, tolerance = .02)
    fm2 <- fscores(modp2, rotate = 'oblimin', verbose = FALSE)
    expect_is(fm2, 'matrix')
    expect_true(mirt:::closeEnough(abs(as.numeric(fm2[1:6,c('F1','F2')])) -
                                       abs(c(2.6215942, 1.8525867, 0.6209020, 1.1175021, 2.4442223, 0.7433109, 2.3733280, 0.7154136, 0.2434079,
                                             0.4614485, 2.3085583, 1.5700213)),
                                   -1e-2, 1e-2))
    fm3 <- fscores(modp3, rotate = 'oblimin', full.scores = TRUE, verbose = FALSE)
    expect_is(fm3, 'matrix')
    fm4 <- fscores(modp4, verbose = FALSE)
    expect_is(fm4, 'matrix')
    expect_true(mirt:::closeEnough(fm4[1:6,'F1'] - c(-2.7320802, -1.4459303, -0.7910009, -0.5438761, -2.5310045, -1.1434060), -1e-2, 1e-2))
    fm5 <- fscores(modp5, verbose = FALSE)
    expect_is(fm5, 'matrix')
    expect_true(mirt:::closeEnough(fm5[1:6,'F1'] - c(-2.7249561, -1.4446593, -0.7364399, -0.5627047, -2.5174376, -1.1732461), -1e-2, 1e-2))

    resmat <- residuals(modp3, type = 'Q3', Theta = fm3[,'F1'], verbose = FALSE)
    expect_equal(as.numeric(resmat), c(1, -0.167, -0.144, 0.084, -0.167, 1, -0.055, -0.218, -0.144, -0.055, 1, -0.446, 0.084, -0.218, -0.446, 1), tolerance=1e-2)
    resmatLD <- residuals(modp3, type = 'LD', verbose = FALSE)
    expect_equal(as.numeric(resmatLD), c(NA, -20.136, -13.296, 19.57, -0.131, NA, 10.902, -21.596, -0.106, 0.096, NA, -17.522, 0.129, -0.136, -0.122, NA), tolerance=1e-2)
    resmatG2 <- residuals(modp3, type = 'LDG2', verbose = FALSE)
    expect_equal(as.numeric(resmatG2), c(NA, -22.905, -12.604, 23.204, -0.14, NA, 10.759, -17.256, -0.104, 0.096, NA, -18.507, 0.14, -0.121, -0.125, NA), tolerance=1e-2)
    cof1 <- coef(modp1)
    expect_is(cof1, 'list')
    cof2 <- coef(modp2, verbose = FALSE)
    expect_is(cof2, 'list')
    IP1 <- itemplot(modp1, 1)
    IP2 <- itemplot(modp2, 1)
    expect_is(IP1, 'trellis')
    expect_is(IP2, 'trellis')

    ##rating scale test
    set.seed(1234)
    a <- matrix(rep(1, 10))
    d <- matrix(c(1,0.5,-.5,-1), 10, 4, byrow = TRUE)
    cc <- seq(-1, 1, length.out=10)
    data <- simdata(a, d + cc, 2000, itemtype = rep('graded',10))
    sv <- mirt(data, 1, itemtype = 'grsm', pars = 'values', verbose=FALSE)
    sv[,'value'] <- c(as.vector(t(cbind(a,d,cc))),0,1)
    grsm <- mirt(data, 1, itemtype = 'grsm', pars = sv, calcNull= FALSE, verbose=FALSE, TOL=1e-5)
#     rsm <- mirt(data, 1, itemtype = 'rsm', calcNull= FALSE, verbose=FALSE, TOL = 1e-3)
    expect_is(grsm, 'ConfirmatoryClass')
#     expect_is(rsm, 'ConfirmatoryClass')
    cfs <- as.numeric(do.call(c, coef(grsm, verbose = FALSE, digits=4)))
    expect_equal(cfs, c(0.997, 1.008, 0.5031, -0.5092, -1.0034, -1, 0.8616, 1.008, 0.5031, -0.5092, -1.0034, -0.7723, 1.0369, 1.008, 0.5031, -0.5092, -1.0034, -0.5635, 0.9486, 1.008, 0.5031, -0.5092, -1.0034, -0.2613, 0.9941, 1.008, 0.5031, -0.5092, -1.0034, -0.0998, 0.9047, 1.008, 0.5031, -0.5092, -1.0034, 0.1646, 0.9475, 1.008, 0.5031, -0.5092, -1.0034, 0.3439, 1.09, 1.008, 0.5031, -0.5092, -1.0034, 0.4608, 0.8921, 1.008, 0.5031, -0.5092, -1.0034, 0.7628, 0.966, 1.008, 0.5031, -0.5092, -1.0034, 0.9779, 0, 1),
                 tolerance = 1e-2)
#     cfs <- as.numeric(do.call(c, coef(rsm, verbose = FALSE, digits=4)))
#     expect_equal(cfs, c(1, 0, 1, 2, 3, 4, 0, -3607.3991, 798.7324, 352.2667, 1218.8, 0, 1, 0, 1, 2, 3, 4, 0, -3607.3991, 798.7324, 352.2667, 1218.8, -182, 1, 0, 1, 2, 3, 4, 0, -3607.3991, 798.7324, 352.2667, 1218.8, -167.2, 1, 0, 1, 2, 3, 4, 0, -3607.3991, 798.7324, 352.2667, 1218.8, -135.4, 1, 0, 1, 2, 3, 4, 0, -3607.3991, 798.7324, 352.2667, 1218.8, -124.4, 1, 0, 1, 2, 3, 4, 0, -3607.3991, 798.7324, 352.2667, 1218.8, -108.6, 1, 0, 1, 2, 3, 4, 0, -3607.3991, 798.7324, 352.2667, 1218.8, -96.2, 1, 0, 1, 2, 3, 4, 0, -3607.3991, 798.7324, 352.2667, 1218.8, -92.4, 1, 0, 1, 2, 3, 4, 0, -3607.3991, 798.7324, 352.2667, 1218.8, -71.8, 1, 0, 1, 2, 3, 4, 0, -3607.3991, 798.7324, 352.2667, 1218.8, -59.2, 0, 1.6093),
#                  tolerance = 1e-2)
#     expect_equal(rsm@df, 9765610)
    expect_equal(grsm@df, 9765601)
    graded <- mirt(data, 1, verbose = FALSE)
    gM2 <- M2(graded, calcNull=TRUE)
    expect_equal(gM2$M2, 6.518739, tolerance = 1e-4)
    expect_equal(gM2$df, 5)
    expect_equal(gM2$CFI, .9961693, tolerance = 1e-4)

    #item and test info
    Theta <- matrix(seq(-4,4,.01))
    x <- extract.item(modp1, 1)
    iinfo <- iteminfo(x, Theta)
    expect_is(iinfo, 'matrix')
    iinfo <- iteminfo(x, Theta, total.info=FALSE)
    expect_is(iinfo, 'matrix')
    tinfo <- testinfo(modp1, Theta)
    expect_is(tinfo, 'matrix')
})
