% Generated by roxygen2 (4.0.2): do not edit by hand
\name{findNextItem}
\alias{findNextItem}
\alias{print.mirtCAT_design}
\title{Find next CAT item}
\usage{
findNextItem(x)

\method{print}{mirtCAT_design}(x, ...)
}
\arguments{
\item{x}{an object of class 'mirtCAT_design' returned from the \code{\link{mirtCAT}} function
  when passing \code{design_elements = TRUE}}

\item{...}{additional arguments to pass}
}
\value{
returns a numeric value indicating the index of the next item to be selected
}
\description{
A function that returns the next item in the computerized adaptive test.
}
\examples{
\dontrun{
# test defined in mirtCAT help file, first example
CATdesign <- mirtCAT(shiny_questions, mod, item_answers=answers, criteria = 'MI',
   design_elements = TRUE)

# returns number 1 in this case, since that's the starting item
findNextItem(CATdesign)

# detemine next item if item 1 and item 10 were answered correctly, and Theta = 0.5
CATdesign <- updateDesign(CATdesign, items = c(1, 10), responses = c(1, 1), Theta = 0.5)
findNextItem(CATdesign)
}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\seealso{
\code{\link{mirtCAT}}, \code{\link{updateDesign}}
}

