% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirtjml_expr.R
\name{mirtjml_expr}
\alias{mirtjml_expr}
\title{Constrained joint maximum likelihood estimation for exploratory item factor analysis on the multidimensional two parameter logistic model.}
\usage{
mirtjml_expr(response, K, theta0 = NULL, A0 = NULL, d0 = NULL,
  cc = NULL, tol = 1e-04, print_proc = TRUE, parallel = FALSE)
}
\arguments{
\item{response}{N by J matrix containing 0/1/NA responses, where N is the number of respondents, J is the number of items, and NA indicates a missing response.}

\item{K}{The number of factors in exploratory item factor analysis.}

\item{theta0}{N by K matrix, the initial value of latent factor scores for each respondent.}

\item{A0}{J by K matrix, the initial value of loading matrix.}

\item{d0}{Length J vector, the initial value of intercept parameters.}

\item{cc}{A constant constraining the magnitude of the norms of person and item parameter vectors.}

\item{tol}{The tolerance for convergence with a default value 1e-4.}

\item{print_proc}{Print the precision during the esitmation procedure with a default value TRUE.}

\item{parallel}{Whether or not enable the parallel computing with a default value FALSE.}
}
\value{
The function returns a list with the following components:
\describe{
  \item{theta_hat}{The estimated person parameter matrix.}
  \item{A_hat}{The estimated loading parameter matrix}
  \item{d_hat}{The estimated intercept parameters.}
}
}
\description{
Constrained joint maximum likelihood estimation for exploratory item factor analysis on the multidimensional two parameter logistic model.
}
\examples{
# load a simulated dataset
attach(data_sim)

# run the exploratory analysis
res <- mirtjml_expr(response, K)


}
\references{
Chen, Y., Li, X., & Zhang, S. (2018). Joint Maximum Likelihood Estimation for High-Dimensional Exploratory Item Factor Analysis. \emph{Psychometrika}, 1-23. <doi:10.1007/s11336-018-9646-5>;
}
