% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ListExperimentFunctions.R
\name{summary.listExperiment}
\alias{summary.listExperiment}
\title{Object summary of the listExperiment class}
\usage{
\method{summary}{listExperiment}(object, digits = 4, ...)
}
\arguments{
\item{object}{Object of class "listExperiment".}

\item{digits}{Number of significant digits to print.}

\item{...}{Additional arguments.}
}
\description{
Summarizes results from a list experiment regression fit using \code{\link{listExperiment}} or \code{\link{bootListExperiment}}.
}
\details{
\code{summary.listExperiment} summarizes the information contained
in a listExperiment object for each list experiment regression sub-model.
}
\examples{
data(gender)

\dontrun{
# Note: substantial computation time
model.gender <- listExperiment(y ~ gender + ageGroup + education +
                                   motherTongue + region + selfPlacement,
                               data = gender, J = 4,
                               treatment = "treatment", direct = "direct",
                               control.constraint = "none",
                               sensitive.response = 0,
                               misreport.treatment = TRUE)
summary(model.gender)
}

}
\references{
Eady, Gregory. 2017 "The Statistical Analysis of Misreporting on Sensitive Survey Questions."
}

