% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Class-missSBM_collection.R
\name{missSBM_collection}
\alias{missSBM_collection}
\title{An R6 class to represent a collection of SBM fits with missing data}
\description{
The function \code{\link[=estimateMissSBM]{estimateMissSBM()}} fits a collection of SBM with missing data for
a varying number of block. These models with class \code{\link{missSBM_fit}}  are stored in an instance
of an object with class \code{\link{missSBM_collection}}, described here.

Fields are accessed via active binding and cannot be changed by the user.

This class comes with a set of R6 methods, some of them being useful for the user and exported
as S3 methods. See the documentation for \code{\link[=show]{show()}}, \code{\link[=print]{print()}} and \code{\link[=smooth]{smooth()}}, the latter being
used to smooth the ICL on a collection of model, as post-treatment.
}
\examples{
## Sample 75\% of dyads in  French political Blogosphere's network data
adjacencyMatrix <- missSBM::frenchblog2007 \%>\%
  igraph::as_adj (sparse = FALSE) \%>\%
  missSBM::observeNetwork(sampling = "dyad", parameters = 0.25)
collection <- estimateMissSBM(adjacencyMatrix, 3:5, sampling = "dyad")
class(collection)

}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{models}}{a list of models}

\item{\code{ICL}}{the vector of Integrated Classification Criterion (ICL) associated to the models in the collection (the smaller, the better)}

\item{\code{bestModel}}{the best model according to the ICL}

\item{\code{vBlocks}}{a vector with the number of blocks}

\item{\code{optimizationStatus}}{a data.frame summarizing the optimization process for all models}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{missSBM_collection$new()}}
\item \href{#method-estimate}{\code{missSBM_collection$estimate()}}
\item \href{#method-smooth}{\code{missSBM_collection$smooth()}}
\item \href{#method-show}{\code{missSBM_collection$show()}}
\item \href{#method-print}{\code{missSBM_collection$print()}}
\item \href{#method-clone}{\code{missSBM_collection$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
constructor for networkSampling
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{missSBM_collection$new(
  partlyObservedNet,
  vBlocks,
  sampling,
  clusterInit,
  cores,
  trace,
  useCov
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{partlyObservedNet}}{An object with class \code{\link{partlyObservedNetwork}}.}

\item{\code{vBlocks}}{vector of integer with the number of blocks in the successively fitted models}

\item{\code{sampling}}{The sampling design for the modelling of missing data: MAR designs ("dyad", "node") and NMAR designs ("double-standard", "block-dyad", "block-node" ,"degree")}

\item{\code{clusterInit}}{Initial method for clustering: either a character in "hierarchical", "spectral" or "kmeans", or a list with \code{length(vBlocks)} vectors, each with size \code{ncol(adjacencyMatrix)}, providing a user-defined clustering. Default is "hierarchical".}

\item{\code{cores}}{integer for number of cores used. Default is 1.}

\item{\code{trace}}{integer for verbosity (0, 1, 2). Default is 1. Useless when \code{cores} > 1}

\item{\code{useCov}}{logical. If covariates are present in partlyObservedNet, should they be used for the inference or of the network sampling design, or just for the SBM inference? default is TRUE.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-estimate"></a>}}
\if{latex}{\out{\hypertarget{method-estimate}{}}}
\subsection{Method \code{estimate()}}{
method to launch the estimation of the collection of models
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{missSBM_collection$estimate(control)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{control}}{a list of parameters controlling the variational EM algorithm. See details of function \code{\link[=estimateMissSBM]{estimateMissSBM()}}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-smooth"></a>}}
\if{latex}{\out{\hypertarget{method-smooth}{}}}
\subsection{Method \code{smooth()}}{
method for performing smoothing of the ICL
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{missSBM_collection$smooth(type, control)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{character, the type of smoothing: forward, backward, both}

\item{\code{control}}{a list of parameters controlling the smoothing. See details of regular function \code{\link[=smooth]{smooth()}}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-show"></a>}}
\if{latex}{\out{\hypertarget{method-show}{}}}
\subsection{Method \code{show()}}{
show method for missSBM_collection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{missSBM_collection$show()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
User friendly print method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{missSBM_collection$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{missSBM_collection$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
