% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_read_pattern.R
\name{data_read_pattern}
\alias{data_read_pattern}
\title{A function to read and re-arrange the data in different ways}
\usage{
data_read_pattern(data, model.eff, model.cost, type = type, center)
}
\arguments{
\item{data}{A data frame in which to find variables supplied in \code{model.eff} and \code{model.cost}. Among these,
effectiveness, cost and treatment indicator (only two arms) variables must always be provided and named 'e', 'c' and 't' respectively.}

\item{model.eff}{A formula expression in conventional \code{R} linear modelling syntax. The response must be a health economics
effectiveness outcome ('e') whose name must correspond to that used in \code{data}, and 
any covariates are given on the right-hand side. If there are no covariates, specify \code{1} on the right hand side.
By default, covariates are placed on the "location" parameter of the distribution through a linear model.}

\item{model.cost}{A formula expression in conventional \code{R} linear modelling syntax. The response must be a health economics
cost outcome ('c') whose name must correspond to that used in \code{data}, and any covariates are given on the right-hand side.
If there are no covariates, specify \code{1} on the right hand side. By default, covariates are placed on the "location" 
parameter of the distribution through a linear model.}

\item{type}{Type of missingness mechanism assumed. Choices are Missing At Random (MAR) and Missing Not At Random (MNAR).}

\item{center}{Logical. If \code{center} is \code{TRUE} all the covariates in the model are centered.}
}
\description{
This internal function imports the data and outputs only those variables that are needed to run the model
according to the information provided by the user.
}
\examples{
# Internal function only
# no examples
#
#
}
\keyword{data}
\keyword{read}
