% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compdist.R, R/standist.R, R/trans_standist.R
\name{q.compdist}
\alias{q.compdist}
\alias{q}
\alias{q.standist}
\alias{q.trans_univdist}
\title{Quantile Function}
\usage{
\method{q}{compdist}(O, p, lower.tail = TRUE, log.p = FALSE, ...)

q(O, p, lower.tail = TRUE, log.p = FALSE, ...)

\method{q}{standist}(O, p, lower.tail = TRUE, log.p = FALSE, ...)

\method{q}{trans_univdist}(O, p, lower.tail = TRUE, log.p = FALSE, ...)
}
\arguments{
\item{O}{distribution object.}

\item{p}{vector of probabilities.}

\item{lower.tail}{logical; if TRUE, probabilities are \eqn{P[X \le x]} otherwise, \eqn{P[X > x]}, default: TRUE.}

\item{log.p}{logical; if TRUE, probabilities \eqn{p} are given as \eqn{log(p)}, default: FALSE.}

\item{...}{further arguments to be passed.}
}
\value{
Vector of computed results.
}
\description{
\code{q} is a generic function that evaluates the quantile function of a distribution object at given values.
}
\details{
Methods of \code{q} function  evaluates any offered
         distribution from package \code{\link{mistr}}. The function makes use of the q[sufix] functions
         as \code{qnorm} or \code{qbeta} and thus, if a new distribution is added,
         these functions must be reachable through the search path.

         The mixture method \code{\link{q.mixdist}} and the default
         method \code{\link{q.default}} have its own help page.
}
\examples{
N <- normdist(1, 3)
q(N, c(NA, 1, 3, 5))

C <- cauchydist()
CC <- compdist(N, C, weights = c(0.5, 0.5), breakpoints = 1)
CCC <- 2*C+5
q(CCC, c(NA, 1, 3, 5))
}
