% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixdist.R
\name{q.mixdist}
\alias{q.mixdist}
\title{Quantile Function of a Mixture Model}
\usage{
\method{q}{mixdist}(O, p, lower.tail = TRUE, log.p = FALSE, ...)
}
\arguments{
\item{O}{mixture distribution object.}

\item{p}{vector of probabilities.}

\item{lower.tail}{logical; if TRUE, probabilities are \eqn{P[X \le x]} otherwise, \eqn{P[X > x]}, default: TRUE.}

\item{log.p}{logical; if TRUE, probabilities \eqn{p} are given as \eqn{log(p)}, default: FALSE.}

\item{...}{further arguments to be passed.}
}
\value{
Vector of computed results.
}
\description{
\code{q.mixdist} is a method that evaluates the quantile function of a mixture distribution object at given values.
}
\details{
Methods of \code{q} function evaluates any offered
         distribution from the package \code{\link{mistr}}. The function makes use of the p[sufix] and q[sufix] functions
         as \code{pnorm} or \code{qbeta} and thus, if a new distribution is added,
         these functions must be reachable through the search path.

         The values are numerically found using the \code{\link[stats]{uniroot}} function, while the starting intervals are found
         automatically. The option parameter \code{tol} specifies the tolerance for the \code{\link[stats]{uniroot}}. 
         Options parameter \code{sub} is used to test whether the CDF at computed values minus \code{sub} is not the same and thus the given value is not an
         infimum. In such case, the root is found one more time for the value \code{p - sub}.

         Other methods \code{\link{q}} and the default
         method \code{\link{q.default}} have its own help page.
}
\examples{
DM <- mixdist(3*binomdist(12, 0.4), -2*poisdist(2)+12, weights=c(0.5, 0.5))
y <- c(0.4, p(DM, c(5, 10, 15, 18)), 0.95)
x <- q(DM, y)
plot(DM, which = "cdf", only_mix=TRUE, xlim1 = c(0, 37))
points(x, y)
}
\seealso{
\code{\link{set_opt}}
}
