% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetaIS.R
\name{MetaIS}
\alias{MetaIS}
\title{Metamodel based Impotance Sampling}
\usage{
MetaIS(dimension, lsf, N = 5e+05, N_alpha = 100, N_DOE = 10 * dimension,
  N1 = N_DOE * 30, Ru = 8, Nmin = 30, Nmax = 200, Ncall_max = 1000,
  precision = 0.05, N_seeds = 2 * dimension, Niter_seed = 10000,
  N_alphaLOO = 5000, K_alphaLOO = 2 * dimension, alpha_int = c(0.1, 10),
  k_margin = 1.96, lower.tail = TRUE, learn_db = NULL, lsf_value = NULL,
  failure = 0, meta_model = NULL, kernel = "matern5_2",
  learn_each_train = TRUE, limit_fun_MH = NULL, failure_MH = 0,
  sampling_strategy = "MH", seeds = NULL,
  seeds_eval = limit_fun_MH(seeds), burnin = 20, plot = FALSE,
  limited_plot = FALSE, add = FALSE, output_dir = NULL, verbose = 0)
}
\arguments{
\item{dimension}{of the input space}

\item{lsf}{the failure defining the failure/safety domain}

\item{N}{size of the Monte-Carlo population for P_epsilon estimate}

\item{N_alpha}{initial size of the Monte-Carlo population for alpha estimate}

\item{N_DOE}{size of the initial DOE got by clustering of the N1 samples}

\item{N1}{size of the initial uniform population sampled in a hypersphere of radius Ru}

\item{Ru}{radius of the hypersphere for the initial sampling}

\item{Nmin}{minimum number of call for the construction step}

\item{Nmax}{maximum number of call for the construction step}

\item{Ncall_max}{maximum number of call for the whole algorithm}

\item{precision}{desired maximal value of cov}

\item{N_seeds}{number of seeds for MH algoritm while generating into the margin (
according to MP*gauss)}

\item{Niter_seed}{maximum number of iteration for the research of a seed for alphaLOO
refinement sampling}

\item{N_alphaLOO}{number of points to sample at each refinement step}

\item{K_alphaLOO}{number of clusters at each refinement step}

\item{alpha_int}{range for alpha to stop construction step}

\item{k_margin}{margin width; default value means that points are classified with more
than 97,5\%}

\item{lower.tail}{specify if one wants to estimate P[lsf(X)<failure] or P[lsf(X)>failure].}

\item{learn_db}{Coordinates of alredy known points}

\item{lsf_value}{Value of the LSF on these points}

\item{failure}{Failure threshold}

\item{meta_model}{Provide here a kriging metamodel from km if wanted}

\item{kernel}{Specify the kernel to use for km}

\item{learn_each_train}{Specify if kernel parameters are re-estimated at each train}

\item{limit_fun_MH}{Define an area of exclusion with a limit function}

\item{failure_MH}{Threshold for the limit_MH function}

\item{sampling_strategy}{Either MH for Metropolis-Hastings of AR for accept-reject}

\item{seeds}{If some points are already known to be in the appropriate subdomain}

\item{seeds_eval}{Value of the metamodel on these points}

\item{burnin}{Burnin parameter for MH}

\item{plot}{Set to TRUE for a full plot, ie refresh at each iteration}

\item{limited_plot}{Set to TRUE for a final plot with final DOE, metamodel and LSF}

\item{add}{If plots are to be added to a current device}

\item{output_dir}{If plots are to be saved in jpeg in a given directory}

\item{verbose}{Either 0 for almost no output, or 1 for medium size or 2 for all outputs}
}
\value{
An object of class \code{list} containing the failure probability
and some more outputs as described below:
\item{p}{The estimated failure probability.}
\item{cov}{The coefficient of variation of the Monte-Carlo probability
estimate.}
\item{Ncall}{The total number of calls to the \code{lsf}.}
\item{learn_db}{The final learning database, ie. all points where \code{lsf}
has been calculated.}
\item{lsf_value}{The value of the \code{lsf} on the learning database.}
\item{meta_fun}{The metamodel approximation of the \code{lsf}. A call output
is a list containing the value and the standard deviation.}
\item{meta_model}{The final metamodel. An S4 object from \pkg{DiceKriging}.
Note that the algorithm enforces the problem to be the estimation of
P[lsf(X)<failure] and so using \sQuote{predict} with this object will
return inverse values if \code{lower.tail==FALSE}; in this scope prefer
using directly \code{meta_fun} which handle this possible issue.}
\item{points}{Points in the failure domain according to the metamodel.}
\item{meta_eval}{Evaluation of the metamodel on these points.}
\item{z_meta}{If \code{plot}==TRUE, the evaluation of the metamodel on
the plot grid.}
}
\description{
Estimate failure probability by MetaIS method.
}
\details{
MetaIS is an Important Sampling based probability estimator. It makes use of
a kriging surogate to approximate the optimal density function, replacing the
indicatrice by its kriging pendant, the probability of being in the failure
domain. In this context, the normallizing constant of this quasi-optimal PDF
is called the \sQuote{augmented failure probability} and the modified
probability \sQuote{alpha}.

After a first uniform Design of Experiments, MetaIS uses an alpha
Leave-One-Out criterion combined with a margin sampling strategy to refine
a kriging-based metamodel. Samples are generated according to the weighted
margin probability with Metropolis-Hastings algorithm and some are selected
by clustering; the \code{N_seeds} are got from an accept-reject strategy on
a standard population.

Once criterion is reached or maximum number of call done, the augmented
failure probability is estimated with a crude Monte-Carlo. Then, a new
population is generated according to the quasi-optimal instrumenal PDF;
\code{burnin} and \code{thinning} are used here and alpha is evaluated.
While the coefficient of variation of alpha estimate is greater than a
given threshold and some computation spots still available (defined by
\code{Ncall_max}) the estimate is refined with extra calculus.

The final probability is the product of p_epsilon and alpha, and final
squared coefficient of variation is the sum of p_epsilon and alpha one's.
}
\note{
Problem is supposed to be defined in the standard space. If not,
use \code{\link{UtoX}} to do so. Furthermore, each time a set of vector
is defined as a matrix, \sQuote{nrow} = \code{dimension} and
\sQuote{ncol} = number of vector to be consistent with \code{as.matrix}
transformation of a vector.

Algorithm calls lsf(X) (where X is a matrix as defined previously) and
expects a vector in return. This allows the user to optimise the computation
of a batch of points, either by vectorial computation, or by the use of
external codes (optimised C or C++ codes for example) and/or parallel
computation; see examples in \link{MonteCarlo}.
}
\examples{
kiureghian = function(x, b=5, kappa=0.5, e=0.1) {
x = as.matrix(x)
b - x[2,] - kappa*(x[1,]-e)^2
}

\donttest{res = MetaIS(dimension=2,lsf=kiureghian,plot=TRUE)

#Compare with crude Monte-Carlo reference value
N = 500000
U = matrix(rnorm(dimension*N),dimension,N)
G = apply(U,2,kiureghian)
P = mean(G<0)
cov = sqrt((1-P)/(N*P))
}

#See impact of kernel choice with Waarts function :
waarts = function(u) {
  u = as.matrix(u)
  b1 = 3+(u[1,]-u[2,])^2/10 - sign(u[1,] + u[2,])*(u[1,]+u[2,])/sqrt(2)
  b2 = sign(u[2,]-u[1,])*(u[1,]-u[2,])+7/sqrt(2)
  val = apply(cbind(b1, b2), 1, min)
}

\donttest{
res = list()
res$matern5_2 = MetaIS(2,waarts,plot=TRUE)
res$matern3_2 = MetaIS(2,waarts,kernel="matern3_2",plot=TRUE)
res$gaussian = MetaIS(2,waarts,kernel="gauss",plot=TRUE)
res$exp = MetaIS(2,waarts,kernel="exp",plot=TRUE)

#Compare with crude Monte-Carlo reference value
N = 500000
U = matrix(rnorm(dimension*N),dimension,N)
G = apply(U,2,waarts)
P = mean(G<0)
cov = sqrt((1-P)/(N*P))
}

}
\author{
Clement WALTER \email{clement.walter@cea.fr}
}
\references{
\itemize{
  \item
  V. Dubourg:\cr
  Meta-modeles adaptatifs pour l'analyse de fiabilite et l'optimisation sous
  containte fiabiliste\cr
  PhD Thesis, Universite Blaise Pascal - Clermont II,2011\cr
  
  \item
  V. Dubourg, B. Sudret, F. Deheeger:\cr
  Metamodel-based importance sampling for structural reliability analysis
  Original Research Article\cr
  Probabilistic Engineering Mechanics, Volume 33, July 2013, Pages 47-57\cr
  
  \item
  V. Dubourg, B. Sudret:\cr
  Metamodel-based importance sampling for reliability sensitivity analysis.\cr
  Accepted for publication in Structural Safety, special issue in the honor
  of Prof. Wilson Tang.(2013)\cr
  
  \item
  V. Dubourg, B. Sudret and J.-M. Bourinet:\cr
  Reliability-based design optimization using kriging surrogates and subset
  simulation.\cr
  Struct. Multidisc. Optim.(2011)\cr
}
}
\seealso{
\code{\link{SubsetSimulation}}
\code{\link{MonteCarlo}}
\code{\link[DiceKriging]{km}} (in package \pkg{DiceKriging})
}

