% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.mplus.R
\name{write.mplus}
\alias{write.mplus}
\title{Write Mplus Data File}
\usage{
write.mplus(x, file = "Mplus_Data.dat", var = TRUE, print = FALSE, na = -99,
            check = TRUE)
}
\arguments{
\item{x}{a matrix or data frame to be written to a tab-delimited file.}

\item{file}{a character string naming a file with or without the file extension '.dat',
e.g., \code{"Mplus_Data.dat"} or \code{"Mplus_Data"}.}

\item{var}{logical: if \code{TRUE}, variable names are written in a text file named
according to the argument\code{file} with the extension \code{_VARNAMES.txt}.}

\item{print}{logical: if \code{TRUE}, variable names are printed on the console.}

\item{na}{a numeric value or character string representing missing values (\code{NA})
in the data set.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}
}
\value{
None.
}
\description{
This function writes a matrix or data frame to a tab-delimited file without variable names and
a text file with variable names. Only numeric values are allowed, missing data will be coded
as a single numeric value.
}
\examples{
\dontrun{
dat <- data.frame(id = 1:5,
                  x = c(NA, 2, 1, 5, 6),
                  y = c(5, 3, 6, 8, 2),
                  z = c(2, 1, 1, NA, 4))

# Write Mplus Data File and a text file with variable names
write.mplus(dat)

# Write Mplus Data File "Data.dat" and a text file with variable name,
# print variable names on the console, missing values coded with -999
write.mplus(dat, file = "Data.dat", print = TRUE, na = -999)
}
}
\references{
Muthen, L. K., & Muthen, B. O. (1998-2017). \emph{Mplus User's Guide} (8th ed.). Muthen & Muthen.
}
\seealso{
\code{\link{read.mplus}}, \code{\link{run.mplus}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
