% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/script.open.R
\name{script.open}
\alias{script.open}
\title{Open R Script, R Markdown script, or SQL Script in RStudio}
\usage{
script.open(path, line = 1, col = 1, cursor = TRUE, run = FALSE,
            echo = TRUE, max.length = 999, spaced = TRUE, check = TRUE)
}
\arguments{
\item{path}{a character string indicating the path of the script.}

\item{line}{a numeric value indicating the line in the script to navigate
to.}

\item{col}{a numeric value indicating the column in the script to
navigate to.}

\item{cursor}{logical: if \code{TRUE} (default), the cursor moves to the
requested location after opening the document.}

\item{run}{logical: if \code{TRUE}, the code is executed after the
document is opened}

\item{echo}{logical: if \code{TRUE}, each expression is printed after
parsing, before evaluation.}

\item{max.length}{a numeric value indicating the maximal number of characters
output for the deparse of a single expression.}

\item{spaced}{logical: if \code{TRUE}, empty line is printed before each
expression.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}
}
\description{
This function is used to open an R script, R markdown script, or SQL script
in RStudio.
}
\details{
The function \code{documentOpen()} in the package \pkg{rstudioapi} is used to
open an R script.
}
\examples{
\dontrun{

# Open  R script file
script.open("script.R")

# Open  R script file and run the code
script.open("script.R", run = TRUE)
}
}
\references{
Ushey, K., Allaire, J., Wickham, H., & Ritchie, G. (2022). rstudioapi: Safely
access the RStudio API. R package version 0.14.
https://CRAN.R-project.org/package=rstudioapi
}
\seealso{
\code{\link{script.close}}, \code{\link{script.new}},
\code{\link{script.save}}, \code{\link{setsource}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
