% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.indicator.R
\name{na.indicator}
\alias{na.indicator}
\title{Missing Data Indicator Matrix}
\usage{
na.indicator(x, as.na = NULL, check = TRUE)
}
\arguments{
\item{x}{a matrix or data frame.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting
the analysis.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}
}
\value{
Returns a matrix or data frame with \eqn{r = 1} if a value is observed, and \eqn{r = 0}
if a value is missing.
}
\description{
This function creates a missing data indicator matrix \eqn{R} that denotes whether
values are observed or missing, i.e., \eqn{r = 1} if a value is observed, and
\eqn{r = 0} if a value is missing.
}
\examples{
dat <- data.frame(x = c(1, NA, NA, 6, 3),
                  y = c(7, NA, 8, 9, NA),
                  z = c(2, NA, 3, NA, 5))

# Create missing data indicator matrix \eqn{R}
na.indicator(dat)
}
\references{
Enders, C. K. (2010). \emph{Applied missing data analysis}. Guilford Press.

Graham, J. W. (2009). Missing data analysis: Making it work in the real world.
\emph{Annual Review of Psychology, 60}, 549-576.
https://doi.org/10.1146/annurev.psych.58.110405.085530

van Buuren, S. (2018). \emph{Flexible imputation of missing data} (2nd ed.). Chapman & Hall.
}
\seealso{
\code{\link{as.na}}, \code{\link{na.as}}, \code{\link{na.auxiliary}},
\code{\link{na.coverage}}, \code{\link{na.descript}}, \code{\link{na.pattern}},
\code{\link{na.prop}}, \code{\link{na.test}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
