% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci.var.R
\name{ci.var}
\alias{ci.var}
\alias{ci.sd}
\title{Confidence Interval for the Variance and Standard Deviation}
\usage{
ci.var(..., data = NULL, method = c("chisq", "bonett"),
       alternative = c("two.sided", "less", "greater"), conf.level = 0.95,
       group = NULL, split = NULL, sort.var = FALSE, na.omit = FALSE,
       digits = 2, as.na = NULL, write = NULL, append = TRUE,
       check = TRUE, output = TRUE)

ci.sd(..., data = NULL, method = c("chisq", "bonett"),
      alternative = c("two.sided", "less", "greater"), conf.level = 0.95,
      group = NULL, split = NULL, sort.var = FALSE, na.omit = FALSE, digits = 2,
      as.na = NULL, write = NULL, append = TRUE,
      check = TRUE, output = TRUE)
}
\arguments{
\item{...}{a numeric vector, matrix or data frame with numeric variables,
i.e., factors and character variables are excluded from \code{x}
before conducting the analysis. Alternatively, an expression
indicating the variable names in \code{data} e.g.,
\code{ci.var(x1, x2, x3, data = dat)}. Note that the operators
\code{.}, \code{+}, \code{-}, \code{~}, \code{:}, \code{::},
and \code{!} can also be used to select variables, see 'Details'
in the \code{\link{df.subset}} function.}

\item{data}{a data frame when specifying one or more variables in the
argument \code{...}. Note that the argument is \code{NULL}
when specifying a numeric vector, matrix or data frame
for the argument \code{...}.}

\item{method}{a character string specifying the method for computing the confidence interval,
must be one of \code{"chisq"}, or \code{"bonett"} (default).}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of
\code{"two.sided"} (default), \code{"greater"} or \code{"less"}.}

\item{conf.level}{a numeric value between 0 and 1 indicating the confidence level of the interval.}

\item{group}{either a character string indicating the variable name of
the grouping variable in \code{...} or \code{data}, or a vector
representing the grouping variable.}

\item{split}{either a character string indicating the variable name of
the split variable in \code{...} or \code{data}, or a vector
representing the split variable.}

\item{sort.var}{logical: if \code{TRUE}, output table is sorted by variables when specifying \code{group}.}

\item{na.omit}{logical: if \code{TRUE}, incomplete cases are removed before conducting the analysis
(i.e., listwise deletion) when specifying more than one outcome variable.}

\item{digits}{an integer value indicating the number of decimal places to be used.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting the analysis.
Note that \code{as.na()} function is only applied to \code{x}, but
not to \code{group} or \code{split}.}

\item{write}{a character string naming a text file with file extension
\code{".txt"} (e.g., \code{"Output.txt"}) for writing the
output into a text file.}

\item{append}{logical: if \code{TRUE} (default), output will be appended
to an existing text file with extension \code{.txt} specified
in \code{write}, if \code{FALSE} existing text file will be
overwritten.}

\item{check}{logical: if \code{TRUE} (default), argument specification is checked.}

\item{output}{logical: if \code{TRUE} (default), output is shown on the console.}
}
\value{
Returns an object of class \code{misty.object}, which is a list with following
entries:
  \item{\code{call}}{function call}
  \item{\code{type}}{type of analysis}
  \item{\code{data}}{list with the input specified in \code{...}, \code{data},                           \code{group}, and \code{split}}
  \item{\code{args}}{specification of function arguments}
  \item{\code{result}}{result table}
}
\description{
The function \code{ci.var} computes the confidence interval for the variance,
and the function \code{ci.sd} computes the confidence interval for the standard
deviation for one or more variables, optionally by a grouping and/or split variable.
}
\details{
The confidence interval based on the chi-square distribution is computed by specifying \code{method = "chisq"},
while the Bonett (2006) confidence interval is requested by specifying \code{method = "bonett"}. By default,
the Bonett confidence interval interval is computed which performs well under moderate departure from
normality, while the confidence interval based on the chi-square distribution is highly sensitive to minor
violations of the normality assumption and its performance does not improve with increasing sample size.
Note that at least four valid observations are needed to compute the Bonett confidence interval.
}
\examples{
# Example 1a: Two-Sided 95% CI for the variance for 'mpg'
ci.var(mtcars$mpg)

# Example 1b: Alternative specification using the 'data' argument
ci.var(mpg, data = mtcars)

# Example 2a: Two-Sided 95% CI for the standard deviation for 'mpg'
ci.sd(mtcars$mpg)

# Example 2b: Alternative specification using the 'data' argument
ci.sd(mpg, data = mtcars)

# Example 3: Two-Sided 95% CI using chi square distribution
ci.var(mtcars$mpg, method = "chisq")

# Example 4: One-Sided 95% CI
ci.var(mtcars$mpg, alternative = "less")

# Example 5: Two-Sided 99% CI
ci.var(mtcars$mpg, conf.level = 0.99)

# Example 6: Two-Sided 95% CI, print results with 3 digits
ci.var(mtcars$mpg, digits = 3)

# Example 7a: Two-Sided 95% CI for 'mpg', 'disp', and 'hp',
# listwise deletion for missing data
ci.var(mtcars[, c("mpg", "disp", "hp")])

# Example 7b: Alternative specification using the 'data' argument
ci.var(mpg:hp, data = mtcars)

# Example 8a: Two-Sided 95% CI, analysis by 'vs' separately
ci.var(mtcars[, c("mpg", "disp", "hp")], group = mtcars$vs)

# Example 8b: Alternative specification using the 'data' argument
ci.var(mpg:hp, data = mtcars, group = "vs")

# Example 9: Two-Sided 95% CI for, analysis by 'vs' separately, sort by variables
ci.var(mtcars[, c("mpg", "disp", "hp")], group = mtcars$vs, sort.var = TRUE)

# Example 10: Two-Sided 95% CI, split analysis by 'vs'
ci.var(mtcars[, c("mpg", "disp", "hp")], split = mtcars$vs)

# Example 11a: Two-Sided 95% CI, analysis by 'vs' separately, split analysis by 'am'
ci.var(mtcars[, c("mpg", "disp", "hp")], group = mtcars$vs, split = mtcars$am)

# Example 11b: Alternative specification using the 'data' argument
ci.var(mpg:hp, data = mtcars, group = "vs", split = "am")

\dontrun{
# Example 12: Write results into a text file
ci.var(mpg:hp, data = mtcars, group = "vs", split = "am", write = "Variance.txt")
}
}
\references{
Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology - Using R and SPSS}.
John Wiley & Sons.

Bonett, D. G. (2006). Approximate confidence interval for standard deviation of nonnormal distributions.
\emph{Computational Statistics and Data Analysis, 50}, 775-782. https://doi.org/10.1016/j.csda.2004.10.003
}
\seealso{
\code{\link{ci.mean}}, \code{\link{ci.mean.diff}}, \code{\link{ci.median}},
\code{\link{ci.prop}}, \code{\link{ci.prop.diff}}, \code{\link{descript}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
