% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/script.copy.R
\name{script.copy}
\alias{script.copy}
\title{Save Copy of the Current Script in RStudio}
\usage{
script.copy(file = NULL, folder = "_R_Script_Archive", create.folder = TRUE,
            time = TRUE, format = "\%Y-\%m-\%d_\%H\%M", overwrite = TRUE,
            check = TRUE)
}
\arguments{
\item{file}{a character string naming the file of the copy without
the file extension \code{".R"}. By default, the file of
the copy has the same name as the original file.}

\item{folder}{a character string naming the folder in which the file
of the copy is saved. If \code{NULL}, the file of the
copy is saved in the same folder as the original file.
By default, the file of the copy is saved into a folder
called \code{"_R_Script_Archive"}.}

\item{create.folder}{logical: if \code{TRUE} (default), folder(s) specified in
the \code{file} argument is created. If \code{FALSE} and
the folder does not exist, then a error message is printed
on the console.}

\item{time}{logical: if \code{TRUE} (default), the current time is
attached to the name of the file specified in the argument
\code{file}.}

\item{format}{a character string indicating the format if the \code{POSIXct}
class resulting from the \code{Sys.time} function. The default
setting provides a character string indicating the year, month, day, minutes, and seconds. See the help page of the \code{\link{format.POSIXct}} function.}

\item{overwrite}{logical: if \code{TRUE} (default) an existing destination
file is overwritten.}

\item{check}{logical: if \code{TRUE} (default), argument specification is
checked.}
}
\description{
This function saves a copy of the current script in RStudio. By default, a
folder called \code{_R_Script_Archive} will be created to save the copy of
the current R script with the current date and time into the folder. Note that
the current R script needs to have a file location before the script can be
copied.
}
\note{
This function uses the \code{getSourceEditorContext()} function in the
\pkg{rstudioapi} package by Kevin Ushey, JJ Allaire, Hadley Wickham, and Gary
Ritchie (2023).
}
\examples{
\dontrun{
# Example 1: Save copy current R script into the folder '_R_Script_Archive'
script.copy()

# Exmample 2: Save current R script as 'R_Script.R' into the folder 'Archive'
script.copy("R_Script", folder = "Archive", time = FALSE)
}
}
\references{
Ushey, K., Allaire, J., Wickham, H., & Ritchie, G. (2023). \emph{rstudioapi: Safely
access the RStudio API}. R package version 0.15.0
https://CRAN.R-project.org/package=rstudioapi
}
\seealso{
\code{\link{script.new}}, \code{\link{script.close}}, \code{\link{script.open}}, \code{\link{script.save}}, \code{\link{setsource}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
