% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cti.R
\name{MapTechniques}
\alias{MapTechniques}
\title{Extract Technique properties from attack pattern object (parsed with RJSONIO::fromJSON)}
\usage{
MapTechniques(attack.pattern = NA, domain = NA)
}
\arguments{
\item{attack.pattern}{list based on STIX}

\item{domain}{must be "pre-attack", "enterprise-attack" or "mobile-attack"}
}
\value{
data.frame compliant with CTI USAGE document
}
\description{
Extract Technique properties from attack pattern object (parsed with RJSONIO::fromJSON)
}
\examples{
\dontrun{
sf <- "https://github.com/mitre/cti/raw/master/<domain>/<object>/<file>.json"
attack.pattern <- RJSONIO::fromJSON(sf)
df.ent.tech <- MapTechniques(attack.pattern, "enerprise-attack")
}
}
