\name{plot.mresid}
\alias{plot.mresid}
\title{
Plot residuals for a fitted mixture of linear regressions.
}
\description{
Plots the residuals against predictors or fitted values using symbols
whose size is proportional to the probability that the associated
observation was generated by the associated component of the model.
}
\usage{
plot.mresid(x, vs.fit=FALSE, whichx=1, shape="disc",
            ngon=20, size=1, xlab=NULL, \dots)
}
\arguments{
\item{x}{
A list with components containing the residuals, the relevant
probabilities, the predictors, and the observations, as returned
by resid.mix.  When plotting against fitted values, it is probably
better to used the standardized residuals, i.e. resid.mix should
be called with std=TRUE.
}
\item{vs.fit}{
Logical argument.  If TRUE the residuals are plotted versus the
fitted values.
}
\item{whichx}{
Indicates which predictor to plot against if there is more than
one; i.e. indicates which column of the x matrix to use.  If vs.fit
is TRUE, whichx is ignored.
}
\item{shape}{
The shape of the plotting symbol; possible values are "disc",
"square", and "diamond".  Partial matching is used so only
the first few letters need be given.
}
\item{ngon}{
The "disc" shape is actually a regular polygon; ngon specifies
how many sides it should have; ignored if shape is not equal
to "disc".
}
\item{size}{
A scale factor to change the absolute sizes of the plotting
symbols; values larger than 1 make the symbols larger; values
less than 1 make them smaller.
}
\item{xlab}{
The x label for the plot; defaults to "x".
}
\item{...}{
Additional arguments to be passed to the polygon function which
actually draws the plotting symbols.
}}
\section{Side Effects}{
A residual plot is produced in whatever device is currently open.
}
\details{
This function is a "method" for plot.  The plot produced is visually
assessed by ignoring or discounting small symbols.
}
\references{
Turner, T. R.  (2000) Estimating the rate of spread of a viral infection
of potato plants via mixtures of regressions.  Appl. Statist. vol. 49,
Part 3, pp. 371 -- 384.
}
\section{ACKNOWLEDGEMENT}{
The idea of creating residual plots for regression mixtures
by making the symbol size proportional to the associated
probability is due to Adrian Baddeley of the University
of Western Australia.
}
\seealso{
\link{bootcomp}, \link{cband}, \link{covmix}, \link{mixreg},
\link{plot.cband}, \link{qq.mix}, \link{resid.mix}
}
\examples{
#See \link{mixreg} for examples.
}
% Converted by Sd2Rd version 1.21.
\keyword{models}
\keyword{regression}
\keyword{hplot}
