% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctx_tree_contexts.R
\name{contexts.ctx_tree}
\alias{contexts.ctx_tree}
\title{Contexts of a context tree}
\usage{
\method{contexts}{ctx_tree}(
  ct,
  type = c("auto", "list", "data.frame"),
  reverse = TRUE,
  frequency = NULL,
  ...
)
}
\arguments{
\item{ct}{a context tree.}

\item{type}{result type (see details).}

\item{reverse}{logical (defaults to FALSE). See details.}

\item{frequency}{specifies the counts to be included in the result
data.frame. The default value of \code{NULL} does not include anything.
\code{"total"} gives the number of occurrences of each context in the original
sequence. \code{"detailed"} includes in addition the break down of these
occurrences into all the possible states.}

\item{...}{additional arguments for the contexts function.}
}
\value{
The list of the contexts represented in this tree or a data.frame
with more content.
}
\description{
This function extracts from a context tree a description of all of its
contexts.
}
\details{
The default result for \code{type="auto"} (or \code{type="list"}) and
\code{frequency=NULL} is the list of all contexts.

Other results are obtained only with \code{type="data.frame"} (or
\code{type="auto"}). In this case the resulting \code{data.frame} has a \code{context}
column storing the contexts. If \code{frequency="total"}, an additional column
named \code{freq} gives the number of occurrences of each context in the series
used to build the tree. If \code{frequency="detailed"}, one additional column is
added per state in the context space. Each column records the number of
times a given context is followed by the corresponding value in the
original series.
}
\section{State order in a context}{
 Notice that contexts are given by default
in the "reverse" order used by the VLMC papers: older values are on the
right. For instance, the context \code{c(0, 1)} is reported if the sequence 1,
then 0 appeared in the time series used to build the context tree. Set
reverse to \code{FALSE} for the reverse convention.
}

\examples{
dts <- sample(as.factor(c("A", "B", "C")), 100, replace = TRUE)
dts_tree <- ctx_tree(dts, max_depth = 3, min_size = 5)
contexts(dts_tree)
contexts(dts_tree, frequency = "total")
contexts(dts_tree, frequency = "detailed")
}
\seealso{
\code{\link[=contexts.ctx_tree]{contexts.ctx_tree()}}, \code{\link[=contexts.vlmc]{contexts.vlmc()}}, \code{\link[=contexts.covlmc]{contexts.covlmc()}}.
}
