% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vlmc_trim.R
\name{trim.vlmc}
\alias{trim.vlmc}
\title{This function returns a trimmed VLMC from which match positions have been
removed.}
\usage{
\method{trim}{vlmc}(ct, ...)
}
\arguments{
\item{ct}{a VLMC.}

\item{...}{additional arguments for the trim function.}
}
\value{
a trimmed VLMC
}
\description{
This function returns a trimmed context tree from which match positions
have been removed.
}
\examples{
## VLMC trimming is generally useless unless match positions were kept
pc <- powerconsumption[powerconsumption$week \%in\% 5:6, ]
dts <- cut(pc$active_power, breaks = 4)
model <- vlmc(dts, keep_match = TRUE)
print(object.size(model))
model <- trim(model)
## memory use should be reduced
print(object.size(model))
nm_model <- vlmc(dts)
print(object.size(nm_model))
nm_model <- trim(nm_model)
## no effect when match positions are not kept
print(object.size(nm_model))
}
