% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setMetabolicRate.R
\name{setMetabolicRate}
\alias{setMetabolicRate}
\alias{getMetabolicRate}
\title{Set metabolic rate}
\usage{
setMetabolicRate(params, metab = NULL, p = NULL, ...)

getMetabolicRate(params)
}
\arguments{
\item{params}{MizerParams}

\item{metab}{Optional. An array (species x size) holding the metabolic rate
for each species at size. If not supplied, a default is set as described in
the section "Setting metabolic rate".}

\item{p}{The allometric metabolic exponent. This is only used if \code{metab}
is not given explicitly and if the exponent is not specified in a \code{p}
column in the \code{species_params}.}

\item{...}{Unused}
}
\value{
MizerParams object with updated metabolic rate. Because of the way
the R language works, \code{setMetabolicRate()} does not make the changes to the
params object that you pass to it but instead returns a new params object.
So to affect the change you call the function in the form
\code{params <- setMetabolicRate(params, ...)}.
}
\description{
Sets the rate at which energy is used for metabolism and activity
}
\section{Setting metabolic rate}{

The metabolic rate is subtracted from the energy income rate to calculate
the rate at which energy is available for growth and reproduction, see
\code{\link[=getEReproAndGrowth]{getEReproAndGrowth()}}. It is measured in grams/year.

If the \code{metab} argument is not supplied, then for each species the
metabolic rate \eqn{k(w)} for an individual of size \eqn{w} is set to
\deqn{k(w) = ks w^p + k w,}
where \eqn{ks w^p} represents the rate of standard metabolism and \eqn{k w}
is the rate at which energy is expended on activity and movement. The values
of \eqn{ks}, \eqn{p} and \eqn{k} are taken from the \code{ks}, \code{p} and
\code{k} columns in the species parameter dataframe. If any of these
parameters are not supplied, the defaults are \eqn{k = 0}, \eqn{p = n} and
\deqn{ks = f_c h \alpha w_{mat}^{n-p},}{ks = f_c * h * alpha * w_mat^(n - p),}
where \eqn{f_c} is the critical feeding level taken from the \code{fc} column
in the species parameter data frame. If the critical feeding level is not
specified, a default of \eqn{f_c = 0.2} is used.
}

\seealso{
Other functions for setting parameters: 
\code{\link{gear_params}()},
\code{\link{resource_params}()},
\code{\link{setExtMort}()},
\code{\link{setFishing}()},
\code{\link{setInitialValues}()},
\code{\link{setInteraction}()},
\code{\link{setMaxIntakeRate}()},
\code{\link{setParams}()},
\code{\link{setPredKernel}()},
\code{\link{setReproduction}()},
\code{\link{setResource}()},
\code{\link{setSearchVolume}()},
\code{\link{species_params}()}
}
\concept{functions for setting parameters}
