% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotDataFrame}
\alias{plotDataFrame}
\title{Make a plot from a data frame}
\usage{
plotDataFrame(
  frame,
  params,
  xlab = waiver(),
  ylab = waiver(),
  xtrans = "identity",
  ytrans = "identity",
  y_ticks = 6,
  highlight = NULL,
  legend_var = NULL,
  wrap_var = NULL
)
}
\arguments{
\item{frame}{A data frame with at least three variables.
The first three variables are used, in that order, as:
\enumerate{
\item Variable to be plotted on x-axis
\item Variable to be plotted on y-axis
\item Grouping variable
}}

\item{params}{A MizerParams object, which is used for the line colours and
line types.}

\item{xlab}{Label for the x-axis}

\item{ylab}{Label for the y-axis}

\item{xtrans}{Transformation for the x-axis. Often "log10" may be useful
instead of the default of "identity".}

\item{ytrans}{Transformation for the y-axis.}

\item{y_ticks}{The approximate number of ticks desired on the y axis}

\item{highlight}{Name or vector of names of the species to be highlighted.}

\item{legend_var}{The name of the variable that should be used in the legend
and to determine the line style. If NULL then the grouping variable is
used for this purpose.}

\item{wrap_var}{Optional. The name of the variable that should be used for
creating wrapped facets.}
}
\description{
This is used internally by most plotting functions.
}
\keyword{internal}
