% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_kernel_funcs.R
\name{power_law_pred_kernel}
\alias{power_law_pred_kernel}
\title{Power-law predation kernel}
\usage{
power_law_pred_kernel(
  ppmr,
  kernel_exp,
  kernel_l_l,
  kernel_u_l,
  kernel_l_r,
  kernel_u_r
)
}
\arguments{
\item{ppmr}{A vector of predator/prey size ratios at which to evaluate the
predation kernel.}

\item{kernel_exp}{The exponent of the power law}

\item{kernel_l_l}{The location of the left, rising sigmoid}

\item{kernel_u_l}{The shape of the left, rising sigmoid}

\item{kernel_l_r}{The location of the right, falling sigmoid}

\item{kernel_u_r}{The shape of the right, falling sigmoid}
}
\value{
A vector giving the value of the predation kernel at each of the
predator/prey mass ratios in the \code{ppmr} argument.
}
\description{
This predation kernel is a power-law, with sigmoidal cut-offs at large and
small predator/prey mass ratios.
}
\details{
The return value is calculated as

\code{
ppmr^kernel_exp /
  (1 + (exp(kernel_l_l) / ppmr)^kernel_u_l) /
  (1 + (ppmr / exp(kernel_l_r))^kernel_u_r) 
}

The parameters need to be given as columns in the species parameter
dataframe.
}
