% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resource_dynamics.R
\name{resource_constant}
\alias{resource_constant}
\title{Keep resource abundance constant}
\usage{
resource_constant(params, n_pp, ...)
}
\arguments{
\item{params}{A \link{MizerParams} object}

\item{n_pp}{A vector of the resource abundance by size}

\item{...}{Unused}
}
\value{
Vector containing resource spectrum at next timestep
}
\description{
This function can be used instead of the standard
\code{\link[=resource_semichemostat]{resource_semichemostat()}} in order to keep the resource
spectrum constant over time.
}
\examples{
\dontrun{
params <- newMultispeciesParams(NS_species_params_gears, NS_interaction,
                                resource_dynamics = "resource_constant")
}
}
\seealso{
Other resource dynamics: 
\code{\link{resource_semichemostat}()}
}
\concept{resource dynamics}
